package org.jboss.hal.client.configuration.subsystem.io;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_IOView extends IOView {

    private final Metadata metadata67;
    private final Metadata metadata68;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_IOView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata67Template = AddressTemplate.of("/{selected.profile}/subsystem=io/worker=*");
        this.metadata67 = mbuiContext.metadataRegistry().lookup(metadata67Template);
        AddressTemplate metadata68Template = AddressTemplate.of("/{selected.profile}/subsystem=io/buffer-pool=*");
        this.metadata68 = mbuiContext.metadataRegistry().lookup(metadata68Template);
        this.expressionElements = new HashMap<>();

        bufferPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("io-buffer-pool-form", metadata68)
            .include("buffer-size", "buffers-per-slice", "direct-buffers")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Buffer Pool", name, metadata68Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata68);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Buffer Pool", name, metadata68Template.resolve(mbuiContext.statementContext(), name), form, metadata68);
            })
            .build();
        workerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("io-worker-form", metadata67)
            .include("io-threads", "stack-size", "task-keepalive", "task-max-threads")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Worker", name, metadata67Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata67);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Worker", name, metadata67Template.resolve(mbuiContext.statementContext(), name), form, metadata67);
            })
            .build();

        bufferPoolTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("io-buffer-pool-table", metadata68)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("io-buffer-pool-table", Ids.ADD), "Buffer Pool",
                metadata68Template, asList("buffer-size", "buffers-per-slice", "direct-buffers"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Buffer Pool", metadata68Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        workerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("io-worker-table", metadata67)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("io-worker-table", Ids.ADD), "Worker",
                metadata67Template, asList("io-threads", "stack-size", "task-keepalive", "task-max-threads"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Worker", metadata67Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html207;
        HTMLElement ioWorkerItemElement = section()
            .add(html207 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Worker</h1><p>${metadata67.getDescription().getDescription()}</p>"))
                .asElement())
            .add(workerTable)
            .add(workerForm)
            .asElement();
        expressionElements.put("html207", html207);
        navigation.addPrimary("io-worker-item", "Worker", "fa fa-cogs", ioWorkerItemElement);
        HTMLElement html210;
        HTMLElement ioBufferPoolItemElement = section()
            .add(html210 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Buffer Pool</h1><p>${metadata68.getDescription().getDescription()}</p>"))
                .asElement())
            .add(bufferPoolTable)
            .add(bufferPoolForm)
            .asElement();
        expressionElements.put("html210", html210);
        navigation.addPrimary("io-buffer-pool-item", "Buffer Pool", "pficon pficon-repository", ioBufferPoolItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(bufferPoolTable);
        registerAttachable(bufferPoolForm);
        registerAttachable(workerTable);
        registerAttachable(workerForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            bufferPoolTable.bindForm(bufferPoolForm);
            workerTable.bindForm(workerForm);

        TemplateUtil.replaceExpression(expressionElements.get("html207"), "${metadata67.getDescription().getDescription()}", String.valueOf(metadata67.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html210"), "${metadata68.getDescription().getDescription()}", String.valueOf(metadata68.getDescription().getDescription()));
    }
}
