package org.jboss.hal.client.configuration.subsystem.security;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_SecurityDomainView extends SecurityDomainView {

    private final Metadata metadata49;
    private final Metadata metadata44;
    private final Metadata metadata45;
    private final Metadata metadata48;
    private final Metadata metadata46;
    private final Metadata metadata47;
    private final Metadata metadata43;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_SecurityDomainView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata49Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/identity-trust=classic/trust-module=*");
        this.metadata49 = mbuiContext.metadataRegistry().lookup(metadata49Template);
        AddressTemplate metadata44Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/authentication=classic/login-module=*");
        this.metadata44 = mbuiContext.metadataRegistry().lookup(metadata44Template);
        AddressTemplate metadata45Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/authorization=classic/policy-module=*");
        this.metadata45 = mbuiContext.metadataRegistry().lookup(metadata45Template);
        AddressTemplate metadata48Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/mapping=classic/mapping-module=*");
        this.metadata48 = mbuiContext.metadataRegistry().lookup(metadata48Template);
        AddressTemplate metadata46Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/audit=classic/provider-module=*");
        this.metadata46 = mbuiContext.metadataRegistry().lookup(metadata46Template);
        AddressTemplate metadata47Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*/acl=classic/acl-module=*");
        this.metadata47 = mbuiContext.metadataRegistry().lookup(metadata47Template);
        AddressTemplate metadata43Template = AddressTemplate.of("/{selected.profile}/subsystem=security/security-domain=*");
        this.metadata43 = mbuiContext.metadataRegistry().lookup(metadata43Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("security-domain-configuration-form", metadata43)
            .onSave((form, changedValues) -> presenter.saveSecurityDomain(changedValues))
            .prepareReset(form -> presenter.resetSecurityDomain(form))
            .build();
        authenticationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-authentication-form", metadata44)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.AUTHENTICATION))
            .prepareReset(form -> presenter.resetModule(form, Module.AUTHENTICATION))
            .build();
        authorizationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-authorization-form", metadata45)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.AUTHORIZATION))
            .prepareReset(form -> presenter.resetModule(form, Module.AUTHORIZATION))
            .build();
        auditForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-audit-form", metadata46)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.AUDIT))
            .prepareReset(form -> presenter.resetModule(form, Module.AUDIT))
            .build();
        aclForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-acl-form", metadata47)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.ACL))
            .prepareReset(form -> presenter.resetModule(form, Module.ACL))
            .build();
        trustForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-trust-form", metadata49)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.TRUST))
            .prepareReset(form -> presenter.resetModule(form, Module.TRUST))
            .build();
        mappingForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-mapping-form", metadata48)
            .onSave((form, changedValues) -> presenter.saveModule(form, changedValues, Module.MAPPING))
            .prepareReset(form -> presenter.resetModule(form, Module.MAPPING))
            .build();

        authenticationTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-authentication-table", metadata44)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addClassicAuthenticationModule(), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/authentication=classic/login-module=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeModule(table, Module.AUTHENTICATION), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/authentication=classic/login-module=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        authorizationTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-authorization-table", metadata45)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addModule(Module.AUTHORIZATION), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/authorization=classic/policy-module=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeModule(table, Module.AUTHORIZATION), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/authorization=classic/policy-module=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        auditTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-audit-table", metadata46)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addModule(Module.AUDIT), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/audit=classic/provider-module=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeModule(table, Module.AUDIT), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/audit=classic/provider-module=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        aclTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-acl-table", metadata47)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addModule(Module.ACL), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/acl=classic/acl-module=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeModule(table, Module.ACL), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/acl=classic/acl-module=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        trustTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-trust-table", metadata49)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addModule(Module.TRUST), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/identity-trust=classic/trust-module=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeModule(table, Module.TRUST), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/identity-trust=classic/trust-module=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        mappingTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-domain-mapping-table", metadata48)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addModule(Module.MAPPING), Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/mapping=classic/mapping-module=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeModule(table, Module.MAPPING), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=security/security-domain=*/mapping=classic/mapping-module=*:remove)"))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html122;
        HTMLElement securityDomainConfigurationItemElement = section()
            .add(html122 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>${metadata43.getDescription().getDescription()}</p>"))
                .asElement())
            .add(configurationForm)
            .asElement();
        expressionElements.put("html122", html122);
        navigation.addPrimary("security-domain-configuration-item", "Configuration", "pficon pficon-settings", securityDomainConfigurationItemElement);
        HTMLElement html124;
        HTMLElement securityDomainAuthenticationItemElement = section()
            .add(html124 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Authentication Module</h1><p>${metadata44.getDescription().getDescription()}</p>"))
                .asElement())
            .add(authenticationTable)
            .add(authenticationForm)
            .asElement();
        expressionElements.put("html124", html124);
        navigation.addPrimary("security-domain-authentication-item", "Authentication", "fa fa-sign-in", securityDomainAuthenticationItemElement);
        HTMLElement html127;
        HTMLElement securityDomainAuthorizationItemElement = section()
            .add(html127 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Authorization Module</h1><p>${metadata45.getDescription().getDescription()}</p>"))
                .asElement())
            .add(authorizationTable)
            .add(authorizationForm)
            .asElement();
        expressionElements.put("html127", html127);
        navigation.addPrimary("security-domain-authorization-item", "Authorization", "fa fa-shield", securityDomainAuthorizationItemElement);
        HTMLElement html130;
        HTMLElement securityDomainAuditItemElement = section()
            .add(html130 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Audit Module</h1><p>${metadata46.getDescription().getDescription()}</p>"))
                .asElement())
            .add(auditTable)
            .add(auditForm)
            .asElement();
        expressionElements.put("html130", html130);
        navigation.addPrimary("security-domain-audit-item", "Audit", "fa fa-file-text-o", securityDomainAuditItemElement);
        HTMLElement html133;
        HTMLElement securityDomainAclItemElement = section()
            .add(html133 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>ACL Module</h1><p>${metadata47.getDescription().getDescription()}</p>"))
                .asElement())
            .add(aclTable)
            .add(aclForm)
            .asElement();
        expressionElements.put("html133", html133);
        navigation.addPrimary("security-domain-acl-item", "ACL", "fa fa-lock", securityDomainAclItemElement);
        HTMLElement html136;
        HTMLElement securityDomainMappingItemElement = section()
            .add(html136 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Mapping Module</h1><p>${metadata48.getDescription().getDescription()}</p>"))
                .asElement())
            .add(mappingTable)
            .add(mappingForm)
            .asElement();
        expressionElements.put("html136", html136);
        navigation.addPrimary("security-domain-mapping-item", "Mapping", "fa fa-exchange", securityDomainMappingItemElement);
        HTMLElement html139;
        HTMLElement securityDomainTrustItemElement = section()
            .add(html139 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Trust Module</h1><p>${metadata49.getDescription().getDescription()}</p>"))
                .asElement())
            .add(trustTable)
            .add(trustForm)
            .asElement();
        expressionElements.put("html139", html139);
        navigation.addPrimary("security-domain-trust-item", "Identity Trust", "fa fa-handshake-o", securityDomainTrustItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(authenticationTable);
        registerAttachable(authenticationForm);
        registerAttachable(authorizationTable);
        registerAttachable(authorizationForm);
        registerAttachable(auditTable);
        registerAttachable(auditForm);
        registerAttachable(aclTable);
        registerAttachable(aclForm);
        registerAttachable(trustTable);
        registerAttachable(trustForm);
        registerAttachable(mappingTable);
        registerAttachable(mappingForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            authenticationTable.bindForm(authenticationForm);
            authorizationTable.bindForm(authorizationForm);
            auditTable.bindForm(auditForm);
            aclTable.bindForm(aclForm);
            trustTable.bindForm(trustForm);
            mappingTable.bindForm(mappingForm);

        TemplateUtil.replaceExpression(expressionElements.get("html122"), "${metadata43.getDescription().getDescription()}", String.valueOf(metadata43.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html124"), "${metadata44.getDescription().getDescription()}", String.valueOf(metadata44.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html127"), "${metadata45.getDescription().getDescription()}", String.valueOf(metadata45.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html130"), "${metadata46.getDescription().getDescription()}", String.valueOf(metadata46.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html133"), "${metadata47.getDescription().getDescription()}", String.valueOf(metadata47.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html136"), "${metadata48.getDescription().getDescription()}", String.valueOf(metadata48.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html139"), "${metadata49.getDescription().getDescription()}", String.valueOf(metadata49.getDescription().getDescription()));
    }
}
