package org.jboss.hal.client.configuration.subsystem.microprofile;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_MicroProfileConfigView extends MicroProfileConfigView {

    private final Metadata metadata93;
    private final Metadata metadata92;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_MicroProfileConfigView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata93Template = AddressTemplate.of("/{selected.profile}/subsystem=microprofile-config-smallrye/config-source-provider=*");
        this.metadata93 = mbuiContext.metadataRegistry().lookup(metadata93Template);
        AddressTemplate metadata92Template = AddressTemplate.of("/{selected.profile}/subsystem=microprofile-config-smallrye/config-source=*");
        this.metadata92 = mbuiContext.metadataRegistry().lookup(metadata92Template);
        this.expressionElements = new HashMap<>();

        configSourceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("microprofile-config-source-form", metadata92)
            .customFormItem("class", attributeDescription -> new ClassFormItem())
            .include("dir")
            .include("properties")
            .include("ordinal")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Config Source", name, metadata92Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata92);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Config Source", name, metadata92Template.resolve(mbuiContext.statementContext(), name), form, metadata92);
            })
            .build();
        configSourceProviderForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("microprofile-config-source-provider-form", metadata93)
            .customFormItem("class", attributeDescription -> new ClassFormItem())
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Config Source Provider", name, metadata93Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata93);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Config Source Provider", name, metadata93Template.resolve(mbuiContext.statementContext(), name), form, metadata93);
            })
            .build();

        configSourceTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("microprofile-config-source-table", metadata92)
            .button(mbuiContext.tableButtonFactory().add(metadata92Template, table -> {
                ModelNodeForm form = new ModelNodeForm.Builder(Ids.build("microprofile-config-source-table", Ids.ADD),
                    metadata92)
                    .fromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("class", attributeDescription -> new ClassFormItem())
                    .include("dir")
                    .include("properties")
                    .include("ordinal")
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("Config Source"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata92Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Config Source", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Config Source", metadata92Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("ordinal")
            .build();
        configSourceProviderTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("microprofile-config-source-provider-table", metadata93)
            .button(mbuiContext.tableButtonFactory().add(metadata93Template, table -> {
                ModelNodeForm form = new ModelNodeForm.Builder(Ids.build("microprofile-config-source-provider-table", Ids.ADD),
                    metadata93)
                    .fromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("class", attributeDescription -> new ClassFormItem())
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("Config Provider"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata93Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Config Provider", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Config Provider", metadata93Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html277;
        HTMLElement microprofileConfigSourceItemElement = section()
            .add(html277 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Config Sources</h1><p>${metadata92.getDescription().getDescription()}</p>"))
                .asElement())
            .add(configSourceTable)
            .add(configSourceForm)
            .asElement();
        expressionElements.put("html277", html277);
        navigation.addPrimary("microprofile-config-source-item", "Config Sources", "fa fa-cogs", microprofileConfigSourceItemElement);
        HTMLElement html280;
        HTMLElement microprofileConfigSourceProviderItemElement = section()
            .add(html280 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Config Providers</h1><p>${metadata93.getDescription().getDescription()}</p>"))
                .asElement())
            .add(configSourceProviderTable)
            .add(configSourceProviderForm)
            .asElement();
        expressionElements.put("html280", html280);
        navigation.addPrimary("microprofile-config-source-provider-item", "Config Providers", "pficon pficon-services", microprofileConfigSourceProviderItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(configSourceTable);
        registerAttachable(configSourceForm);
        registerAttachable(configSourceProviderTable);
        registerAttachable(configSourceProviderForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            configSourceTable.bindForm(configSourceForm);
            configSourceProviderTable.bindForm(configSourceProviderForm);

        TemplateUtil.replaceExpression(expressionElements.get("html277"), "${metadata92.getDescription().getDescription()}", String.valueOf(metadata92.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html280"), "${metadata93.getDescription().getDescription()}", String.valueOf(metadata93.getDescription().getDescription()));
    }
}
