package org.jboss.hal.client.configuration.subsystem.modcluster;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_ModclusterView extends ModclusterView {

    private final Metadata metadata6;
    private final Metadata metadata7;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_ModclusterView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata6Template = AddressTemplate.of("/{selected.profile}/subsystem=modcluster/mod-cluster-config=configuration");
        this.metadata6 = mbuiContext.metadataRegistry().lookup(metadata6Template);
        AddressTemplate metadata7Template = AddressTemplate.of("/{selected.profile}/subsystem=modcluster/mod-cluster-config=configuration/ssl=configuration");
        this.metadata7 = mbuiContext.metadataRegistry().lookup(metadata7Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new GroupedForm.Builder<org.jboss.hal.dmr.ModelNode>("modcluster-configuration", metadata6)
            .customGroup("advertising", "Advertising")
                .include("connector", "load-balancing-group", "balancer", "advertise-socket", "advertise-security-key", "advertise")
            .end()
            .customGroup("sessions", "Sessions")
                .include("sticky-session", "sticky-session-force", "sticky-session-remove")
            .end()
            .customGroup("web-contexts", "Web Contexts")
                .include("auto-enable-context", "excluded-contexts")
            .end()
            .customGroup("proxies", "Proxies")
                .include("proxy-url", "proxies")
            .end()
            .customGroup("networking", "Networking")
                .include("node-timeout", "socket-timeout", "stop-context-timeout", "max-attempts", "flush-packets", "flush-wait", "ping", "ttl", "worker-timeout")
            .end()
            .onSave((form, changedValues) -> saveSingletonForm("Configuration", metadata6Template.resolve(mbuiContext.statementContext()), changedValues, metadata6))
            .prepareReset(form -> resetSingletonForm("Configuration", metadata6Template.resolve(mbuiContext.statementContext()), form, metadata6))
            .build();
        sslForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("modcluster-ssl-form", metadata7)
            .singleton(
                () -> new Operation.Builder(metadata7Template.resolve(mbuiContext.statementContext()), READ_RESOURCE_OPERATION).build(),
                () -> addSingleton("modcluster-ssl-form", "SSL", metadata7Template))
            .prepareRemove(form -> removeSingletonForm("SSL", metadata7Template.resolve(mbuiContext.statementContext()), form))
            .include("key-alias", "password", "ca-certificate-file", "certificate-key-file", "cipher-suite", "ca-revocation-url", "protocol")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("SSL", metadata7Template.resolve(mbuiContext.statementContext()), changedValues, metadata7))
            .prepareReset(form -> resetSingletonForm("SSL", metadata7Template.resolve(mbuiContext.statementContext()), form, metadata7))
            .build();


        navigation = new VerticalNavigation();
        HTMLElement html18;
        HTMLElement modclusterConfigurationItemElement = section()
            .add(html18 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>${metadata6.getDescription().getDescription()}</p>"))
                .asElement())
            .add(configurationForm)
            .asElement();
        expressionElements.put("html18", html18);
        navigation.addPrimary("modcluster-configuration-item", "Configuration", "pficon pficon-settings", modclusterConfigurationItemElement);
        HTMLElement html20;
        HTMLElement modclusterSslItemElement = section()
            .add(html20 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>SSL</h1><p>${metadata7.getDescription().getDescription()}</p>"))
                .asElement())
            .add(sslForm)
            .asElement();
        expressionElements.put("html20", html20);
        navigation.addPrimary("modcluster-ssl-item", "SSL", "fa fa-lock", modclusterSslItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(sslForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();


        TemplateUtil.replaceExpression(expressionElements.get("html18"), "${metadata6.getDescription().getDescription()}", String.valueOf(metadata6.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html20"), "${metadata7.getDescription().getDescription()}", String.valueOf(metadata7.getDescription().getDescription()));
    }
}
