package org.jboss.hal.client.configuration.subsystem.logging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_LoggingView extends LoggingView {

    private final Metadata metadata133;
    private final Metadata metadata139;
    private final Metadata metadata137;
    private final Metadata metadata136;
    private final Metadata metadata132;
    private final Metadata metadata129;
    private final Metadata metadata131;
    private final Metadata metadata138;
    private final Metadata metadata134;
    private final Metadata metadata141;
    private final Metadata metadata135;
    private final Metadata metadata140;
    private final Metadata metadata130;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_LoggingView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata133Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*");
        this.metadata133 = mbuiContext.metadataRegistry().lookup(metadata133Template);
        AddressTemplate metadata139Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*");
        this.metadata139 = mbuiContext.metadataRegistry().lookup(metadata139Template);
        AddressTemplate metadata137Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*");
        this.metadata137 = mbuiContext.metadataRegistry().lookup(metadata137Template);
        AddressTemplate metadata136Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*");
        this.metadata136 = mbuiContext.metadataRegistry().lookup(metadata136Template);
        AddressTemplate metadata132Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*");
        this.metadata132 = mbuiContext.metadataRegistry().lookup(metadata132Template);
        AddressTemplate metadata129Template = AddressTemplate.of("/{selected.profile}/subsystem=logging");
        this.metadata129 = mbuiContext.metadataRegistry().lookup(metadata129Template);
        AddressTemplate metadata131Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/logger=*");
        this.metadata131 = mbuiContext.metadataRegistry().lookup(metadata131Template);
        AddressTemplate metadata138Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*");
        this.metadata138 = mbuiContext.metadataRegistry().lookup(metadata138Template);
        AddressTemplate metadata134Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*");
        this.metadata134 = mbuiContext.metadataRegistry().lookup(metadata134Template);
        AddressTemplate metadata141Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*");
        this.metadata141 = mbuiContext.metadataRegistry().lookup(metadata141Template);
        AddressTemplate metadata135Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*");
        this.metadata135 = mbuiContext.metadataRegistry().lookup(metadata135Template);
        AddressTemplate metadata140Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*");
        this.metadata140 = mbuiContext.metadataRegistry().lookup(metadata140Template);
        AddressTemplate metadata130Template = AddressTemplate.of("/{selected.profile}/subsystem=logging/root-logger=ROOT");
        this.metadata130 = mbuiContext.metadataRegistry().lookup(metadata130Template);
        this.expressionElements = new HashMap<>();

        loggingConfigForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("logging-config-form", metadata129)
            .onSave((form, changedValues) -> saveSingletonForm("Logging Configuration", metadata129Template.resolve(mbuiContext.statementContext()), changedValues, metadata129))
            .prepareReset(form -> resetSingletonForm("Logging Configuration", metadata129Template.resolve(mbuiContext.statementContext()), form, metadata129))
            .build();
        rootLoggerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("logging-root-logger-form", metadata130)
            .include("level", "handlers", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Root Logger", metadata130Template.resolve(mbuiContext.statementContext()), changedValues, metadata130))
            .prepareReset(form -> resetSingletonForm("Root Logger", metadata130Template.resolve(mbuiContext.statementContext()), form, metadata130))
            .build();
        List<AddressTemplate> rootLoggerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
        rootLoggerForm.getFormItem("handlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), rootLoggerFormTemplates));
        loggerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-category-form", metadata131)
            .include("category", "level", "handlers", "use-parent-handlers", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Category", name, metadata131Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata131);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Category", name, metadata131Template.resolve(mbuiContext.statementContext(), name), form, metadata131);
            })
            .build();
        List<AddressTemplate> loggerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
        loggerForm.getFormItem("handlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), loggerFormTemplates));
        consoleHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-console-form", metadata133)
            .include("level", "target", "autoflush", "formatter", "named-formatter", "enabled", "encoding", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Console Handler", name, metadata133Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata133);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Console Handler", name, metadata133Template.resolve(mbuiContext.statementContext(), name), form, metadata133);
            })
            .build();
        List<AddressTemplate> consoleHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
        consoleHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), consoleHandlerFormTemplates));
        fileHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-file-form", metadata135)
            .customFormItem("file", attributeDescription -> new FileFormItem())
            .include("level")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("File Handler", name, metadata135Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata135);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("File Handler", name, metadata135Template.resolve(mbuiContext.statementContext(), name), form, metadata135);
            })
            .build();
        List<AddressTemplate> fileHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
        fileHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), fileHandlerFormTemplates));
        periodicHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-periodic-rotating-file-form", metadata136)
            .customFormItem("file", attributeDescription -> new FileFormItem())
            .include("suffix")
            .include("level")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Periodic Rotating File Handler", name, metadata136Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata136);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Periodic Rotating File Handler", name, metadata136Template.resolve(mbuiContext.statementContext(), name), form, metadata136);
            })
            .build();
        List<AddressTemplate> periodicHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
        periodicHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), periodicHandlerFormTemplates));
        periodicSizeHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-periodic-size-rotating-file-form", metadata137)
            .customFormItem("file", attributeDescription -> new FileFormItem())
            .include("suffix")
            .include("level")
            .include("rotate-size")
            .include("rotate-on-boot")
            .include("max-backup-index")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Periodic Size Rotating File Handler", name, metadata137Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata137);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Periodic Size Rotating File Handler", name, metadata137Template.resolve(mbuiContext.statementContext(), name), form, metadata137);
            })
            .build();
        List<AddressTemplate> periodicSizeHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
        periodicSizeHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), periodicSizeHandlerFormTemplates));
        sizeHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-size-rotating-file-form", metadata138)
            .customFormItem("file", attributeDescription -> new FileFormItem())
            .include("suffix")
            .include("level")
            .include("rotate-size")
            .include("rotate-on-boot")
            .include("max-backup-index")
            .include("append")
            .include("autoflush")
            .include("formatter")
            .include("named-formatter")
            .include("enabled")
            .include("encoding")
            .include("filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Size Rotating File Handler", name, metadata138Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata138);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Size Rotating File Handler", name, metadata138Template.resolve(mbuiContext.statementContext(), name), form, metadata138);
            })
            .build();
        List<AddressTemplate> sizeHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
        sizeHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), sizeHandlerFormTemplates));
        asyncHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-async-form", metadata132)
            .include("level", "subhandlers", "queue-length", "overflow-action", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Async Handler", name, metadata132Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata132);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Async Handler", name, metadata132Template.resolve(mbuiContext.statementContext(), name), form, metadata132);
            })
            .build();
        List<AddressTemplate> asyncHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
        asyncHandlerForm.getFormItem("subhandlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), asyncHandlerFormTemplates));
        customHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-custom-form", metadata134)
            .include("level", "module", "class", "properties", "formatter", "named-formatter", "enabled", "encoding", "filter-spec")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Custom Handler", name, metadata134Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata134);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Custom Handler", name, metadata134Template.resolve(mbuiContext.statementContext(), name), form, metadata134);
            })
            .build();
        List<AddressTemplate> customHandlerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=logging/pattern-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/json-formatter=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=logging/xml-formatter=*"));
        customHandlerForm.getFormItem("named-formatter").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), customHandlerFormTemplates));
        syslogHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-syslog-form", metadata139)
            .include("level", "syslog-format", "hostname", "server-address", "port", "app-name", "facility", "enabled")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Syslog Handler", name, metadata139Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata139);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Syslog Handler", name, metadata139Template.resolve(mbuiContext.statementContext(), name), form, metadata139);
            })
            .build();
        customFormatterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-formatter-custom-form", metadata140)
            .include("class", "module", "properties")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Custom Formatter", name, metadata140Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata140);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Custom Formatter", name, metadata140Template.resolve(mbuiContext.statementContext(), name), form, metadata140);
            })
            .build();
        patternFormatterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("logging-formatter-pattern-form", metadata141)
            .include("color-map", "pattern")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Pattern Formatter", name, metadata141Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata141);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Pattern Formatter", name, metadata141Template.resolve(mbuiContext.statementContext(), name), form, metadata141);
            })
            .build();

        loggerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-category-table", metadata131)
            .button(mbuiContext.tableButtonFactory().add(metadata131Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("logging-category-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("Category"),
                    metadata131,
                    asList("level", "handlers", "use-parent-handlers"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata131Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Category", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                List<AddressTemplate> loggerTableTemplates = asList(
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/async-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
                dialog.getForm().getFormItem("handlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), mbuiContext.statementContext(), loggerTableTemplates));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Category", metadata131Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("category", "level")
            .build();
        consoleHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-console-table", metadata133)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("logging-handler-console-table", Ids.ADD), "Console Handler",
                metadata133Template, asList("level", "target", "formatter"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Console Handler", metadata133Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "level", "target")
            .build();
        fileHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-file-table", metadata135)
            .button(mbuiContext.tableButtonFactory().add(metadata135Template, table -> {
                ModelNodeForm form = new ModelNodeForm.Builder(Ids.build("logging-handler-file-table", Ids.ADD),
                    metadata135)
                    .fromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("file", attributeDescription -> new FileFormItem())
                    .include("level")
                    .include("formatter")
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("File Handler"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata135Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("File Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("File Handler", metadata135Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        periodicHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-periodic-rotating-file-table", metadata136)
            .button(mbuiContext.tableButtonFactory().add(metadata136Template, table -> {
                ModelNodeForm form = new ModelNodeForm.Builder(Ids.build("logging-handler-periodic-rotating-file-table", Ids.ADD),
                    metadata136)
                    .fromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("file", attributeDescription -> new FileFormItem())
                    .include("suffix")
                    .include("level")
                    .include("formatter")
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("Periodic Rotating File Handler"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata136Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Periodic Rotating File Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Periodic Rotating File Handler", metadata136Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        periodicSizeHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-periodic-size-rotating-file-table", metadata137)
            .button(mbuiContext.tableButtonFactory().add(metadata137Template, table -> {
                ModelNodeForm form = new ModelNodeForm.Builder(Ids.build("logging-handler-periodic-size-rotating-file-table", Ids.ADD),
                    metadata137)
                    .fromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("file", attributeDescription -> new FileFormItem())
                    .include("suffix")
                    .include("level")
                    .include("formatter")
                    .include("rotate-size")
                    .include("max-backup-index")
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("Periodic Size Rotating File Handler"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata137Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Periodic Size Rotating File Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Periodic Size Rotating File Handler", metadata137Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        sizeHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-size-rotating-file-table", metadata138)
            .button(mbuiContext.tableButtonFactory().add(metadata138Template, table -> {
                ModelNodeForm form = new ModelNodeForm.Builder(Ids.build("logging-handler-size-rotating-file-table", Ids.ADD),
                    metadata138)
                    .fromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("file", attributeDescription -> new FileFormItem())
                    .include("suffix")
                    .include("level")
                    .include("formatter")
                    .include("rotate-size")
                    .include("max-backup-index")
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("Size Rotating File Handler"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata138Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Size Rotating File Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Size Rotating File Handler", metadata138Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name")
            .column("level")
            .column("file", (cell, type, row, meta) -> Logging.getFilename(row))
            .build();
        asyncHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-async-table", metadata132)
            .button(mbuiContext.tableButtonFactory().add(metadata132Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("logging-handler-async-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("Async Handler"),
                    metadata132,
                    asList("level", "subhandlers", "queue-length", "overflow-action"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata132Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Async Handler", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                List<AddressTemplate> asyncHandlerTableTemplates = asList(
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/console-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/custom-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/periodic-size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/size-rotating-file-handler=*"), 
                    AddressTemplate.of("/{selected.profile}/subsystem=logging/syslog-handler=*"));
                dialog.getForm().getFormItem("subhandlers").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), mbuiContext.statementContext(), asyncHandlerTableTemplates));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Async Handler", metadata132Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "level")
            .build();
        customHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-custom-table", metadata134)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("logging-handler-custom-table", Ids.ADD), "Custom Handler",
                metadata134Template, asList("level", "module", "class", "formatter"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Custom Handler", metadata134Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "level")
            .build();
        syslogHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-handler-syslog-table", metadata139)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("logging-handler-syslog-table", Ids.ADD), "Syslog Handler",
                metadata139Template, asList("level", "syslog-format", "hostname", "server-address", "port", "app-name", "facility"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Syslog Handler", metadata139Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("level")
            .build();
        customFormatterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-formatter-custom-table", metadata140)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("logging-formatter-custom-table", Ids.ADD), "Custom Formatter",
                metadata140Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Custom Formatter", metadata140Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        patternFormatterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("logging-formatter-pattern-table", metadata141)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("logging-formatter-pattern-table", Ids.ADD), "Pattern Formatter",
                metadata141Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Pattern Formatter", metadata141Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("pattern")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html385;
        HTMLElement loggingConfigItemElement = section()
            .add(html385 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>${metadata129.getDescription().getDescription()}</p>"))
                .asElement())
            .add(loggingConfigForm)
            .asElement();
        expressionElements.put("html385", html385);
        navigation.addPrimary("logging-config-item", "Configuration", "pficon pficon-settings", loggingConfigItemElement);
        HTMLElement html387;
        HTMLElement loggingRootLoggerItemElement = section()
            .add(html387 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1 id=\"logging-root-logger-header\">Root Logger</h1><p id=\"logging-root-logger-description\">${metadata130.getDescription().getDescription()}</p>"))
                .asElement())
            .add(rootLoggerForm)
            .asElement();
        expressionElements.put("html387", html387);
        navigation.addPrimary("logging-root-logger-item", "Root Logger", "fa fa-sitemap", loggingRootLoggerItemElement);
        HTMLElement html389;
        HTMLElement loggingCategoryItemElement = section()
            .add(html389 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Categories</h1><p>${metadata131.getDescription().getDescription()}</p>"))
                .asElement())
            .add(loggerTable)
            .add(loggerForm)
            .asElement();
        expressionElements.put("html389", html389);
        navigation.addPrimary("logging-category-item", "Categories", "pficon pficon-repository", loggingCategoryItemElement);
        navigation.addPrimary("logging-handler-item", "Handler", "fa fa-cogs");
        HTMLElement html392;
        HTMLElement loggingHandlerAsyncItemElement = section()
            .add(html392 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Async Handler</h1><p>${metadata132.getDescription().getDescription()}</p>"))
                .asElement())
            .add(asyncHandlerTable)
            .add(asyncHandlerForm)
            .asElement();
        expressionElements.put("html392", html392);
        navigation.addSecondary("logging-handler-item", "logging-handler-async-item", "Async Handler", loggingHandlerAsyncItemElement);
        HTMLElement html395;
        HTMLElement loggingHandlerConsoleItemElement = section()
            .add(html395 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Console Handler</h1><p>${metadata133.getDescription().getDescription()}</p>"))
                .asElement())
            .add(consoleHandlerTable)
            .add(consoleHandlerForm)
            .asElement();
        expressionElements.put("html395", html395);
        navigation.addSecondary("logging-handler-item", "logging-handler-console-item", "Console Handler", loggingHandlerConsoleItemElement);
        HTMLElement html398;
        HTMLElement loggingHandlerCustomItemElement = section()
            .add(html398 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Handler</h1><p>${metadata134.getDescription().getDescription()}</p>"))
                .asElement())
            .add(customHandlerTable)
            .add(customHandlerForm)
            .asElement();
        expressionElements.put("html398", html398);
        navigation.addSecondary("logging-handler-item", "logging-handler-custom-item", "Custom Handler", loggingHandlerCustomItemElement);
        HTMLElement html401;
        HTMLElement loggingHandlerFileItemElement = section()
            .add(html401 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>File Handler</h1><p>${metadata135.getDescription().getDescription()}</p>"))
                .asElement())
            .add(fileHandlerTable)
            .add(fileHandlerForm)
            .asElement();
        expressionElements.put("html401", html401);
        navigation.addSecondary("logging-handler-item", "logging-handler-file-item", "File Handler", loggingHandlerFileItemElement);
        HTMLElement html404;
        HTMLElement loggingHandlerPeriodicRotatingFileItemElement = section()
            .add(html404 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Periodic Handler</h1><p>${metadata136.getDescription().getDescription()}</p>"))
                .asElement())
            .add(periodicHandlerTable)
            .add(periodicHandlerForm)
            .asElement();
        expressionElements.put("html404", html404);
        navigation.addSecondary("logging-handler-item", "logging-handler-periodic-rotating-file-item", "Periodic Handler", loggingHandlerPeriodicRotatingFileItemElement);
        HTMLElement html407;
        HTMLElement loggingHandlerPeriodicSizeRotatingFileItemElement = section()
            .add(html407 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Periodic Size Handler</h1><p>${metadata137.getDescription().getDescription()}</p>"))
                .asElement())
            .add(periodicSizeHandlerTable)
            .add(periodicSizeHandlerForm)
            .asElement();
        expressionElements.put("html407", html407);
        navigation.addSecondary("logging-handler-item", "logging-handler-periodic-size-rotating-file-item", "Periodic Size Handler", loggingHandlerPeriodicSizeRotatingFileItemElement);
        HTMLElement html410;
        HTMLElement loggingHandlerSizeRotatingFileItemElement = section()
            .add(html410 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Size Handler</h1><p>${metadata138.getDescription().getDescription()}</p>"))
                .asElement())
            .add(sizeHandlerTable)
            .add(sizeHandlerForm)
            .asElement();
        expressionElements.put("html410", html410);
        navigation.addSecondary("logging-handler-item", "logging-handler-size-rotating-file-item", "Size Handler", loggingHandlerSizeRotatingFileItemElement);
        HTMLElement html413;
        HTMLElement loggingHandlerSyslogItemElement = section()
            .add(html413 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Syslog Handler</h1><p>${metadata139.getDescription().getDescription()}</p>"))
                .asElement())
            .add(syslogHandlerTable)
            .add(syslogHandlerForm)
            .asElement();
        expressionElements.put("html413", html413);
        navigation.addSecondary("logging-handler-item", "logging-handler-syslog-item", "Syslog Handler", loggingHandlerSyslogItemElement);
        navigation.addPrimary("logging-formatter-item", "Formatter", "fa fa-paint-brush");
        HTMLElement html416;
        HTMLElement loggingFormatterCustomItemElement = section()
            .add(html416 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Formatter</h1><p>${metadata140.getDescription().getDescription()}</p>"))
                .asElement())
            .add(customFormatterTable)
            .add(customFormatterForm)
            .asElement();
        expressionElements.put("html416", html416);
        navigation.addSecondary("logging-formatter-item", "logging-formatter-custom-item", "Custom Formatter", loggingFormatterCustomItemElement);
        HTMLElement html419;
        HTMLElement loggingFormatterPatternItemElement = section()
            .add(html419 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Pattern Formatter</h1><p>${metadata141.getDescription().getDescription()}</p>"))
                .asElement())
            .add(patternFormatterTable)
            .add(patternFormatterForm)
            .asElement();
        expressionElements.put("html419", html419);
        navigation.addSecondary("logging-formatter-item", "logging-formatter-pattern-item", "Pattern Formatter", loggingFormatterPatternItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(loggingConfigForm);
        registerAttachable(rootLoggerForm);
        registerAttachable(loggerTable);
        registerAttachable(loggerForm);
        registerAttachable(consoleHandlerTable);
        registerAttachable(consoleHandlerForm);
        registerAttachable(fileHandlerTable);
        registerAttachable(fileHandlerForm);
        registerAttachable(periodicHandlerTable);
        registerAttachable(periodicHandlerForm);
        registerAttachable(periodicSizeHandlerTable);
        registerAttachable(periodicSizeHandlerForm);
        registerAttachable(sizeHandlerTable);
        registerAttachable(sizeHandlerForm);
        registerAttachable(asyncHandlerTable);
        registerAttachable(asyncHandlerForm);
        registerAttachable(customHandlerTable);
        registerAttachable(customHandlerForm);
        registerAttachable(syslogHandlerTable);
        registerAttachable(syslogHandlerForm);
        registerAttachable(customFormatterTable);
        registerAttachable(customFormatterForm);
        registerAttachable(patternFormatterTable);
        registerAttachable(patternFormatterForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            loggerTable.bindForm(loggerForm);
            consoleHandlerTable.bindForm(consoleHandlerForm);
            fileHandlerTable.bindForm(fileHandlerForm);
            periodicHandlerTable.bindForm(periodicHandlerForm);
            periodicSizeHandlerTable.bindForm(periodicSizeHandlerForm);
            sizeHandlerTable.bindForm(sizeHandlerForm);
            asyncHandlerTable.bindForm(asyncHandlerForm);
            customHandlerTable.bindForm(customHandlerForm);
            syslogHandlerTable.bindForm(syslogHandlerForm);
            customFormatterTable.bindForm(customFormatterForm);
            patternFormatterTable.bindForm(patternFormatterForm);

        TemplateUtil.replaceExpression(expressionElements.get("html385"), "${metadata129.getDescription().getDescription()}", String.valueOf(metadata129.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html387"), "${metadata130.getDescription().getDescription()}", String.valueOf(metadata130.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html389"), "${metadata131.getDescription().getDescription()}", String.valueOf(metadata131.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html392"), "${metadata132.getDescription().getDescription()}", String.valueOf(metadata132.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html395"), "${metadata133.getDescription().getDescription()}", String.valueOf(metadata133.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html398"), "${metadata134.getDescription().getDescription()}", String.valueOf(metadata134.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html401"), "${metadata135.getDescription().getDescription()}", String.valueOf(metadata135.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html404"), "${metadata136.getDescription().getDescription()}", String.valueOf(metadata136.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html407"), "${metadata137.getDescription().getDescription()}", String.valueOf(metadata137.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html410"), "${metadata138.getDescription().getDescription()}", String.valueOf(metadata138.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html413"), "${metadata139.getDescription().getDescription()}", String.valueOf(metadata139.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html416"), "${metadata140.getDescription().getDescription()}", String.valueOf(metadata140.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html419"), "${metadata141.getDescription().getDescription()}", String.valueOf(metadata141.getDescription().getDescription()));
    }
}
