package org.jboss.hal.client.configuration.subsystem.deploymentscanner;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_DeploymentScannerView extends DeploymentScannerView {

    private final Metadata metadata24;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_DeploymentScannerView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata24Template = AddressTemplate.of("/{selected.profile}/subsystem=deployment-scanner/scanner=*");
        this.metadata24 = mbuiContext.metadataRegistry().lookup(metadata24Template);
        this.expressionElements = new HashMap<>();

        form = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("deployment-scanner-form", metadata24)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Deployment Scanner", name, metadata24Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata24);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Deployment Scanner", name, metadata24Template.resolve(mbuiContext.statementContext(), name), form, metadata24);
            })
            .build();

        table = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("deployment-scanner-table", metadata24)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("deployment-scanner-table", Ids.ADD), "Scanner",
                metadata24Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Scanner", metadata24Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();

        HTMLElement html70;
        HTMLElement root = row()
            .add(column()
                .add(html70 = div()
                    .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Scanners</h1><p>${metadata24.getDescription().getDescription()}</p>"))
                    .asElement())
                                .add(table)
                                .add(form)
                )
            .asElement();
        expressionElements.put("html70", html70);

        registerAttachable(table);
        registerAttachable(form);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            table.bindForm(form);

        TemplateUtil.replaceExpression(expressionElements.get("html70"), "${metadata24.getDescription().getDescription()}", String.valueOf(metadata24.getDescription().getDescription()));
    }
}
