package org.jboss.hal.client.runtime.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_ServerView extends ServerView {

    private final Metadata metadata87;
    private final Metadata metadata88;
    private final Metadata metadata86;
    private final Metadata metadata90;
    private final Metadata metadata89;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_ServerView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata87Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/interface=*");
        this.metadata87 = mbuiContext.metadataRegistry().lookup(metadata87Template);
        AddressTemplate metadata88Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/jvm=*");
        this.metadata88 = mbuiContext.metadataRegistry().lookup(metadata88Template);
        AddressTemplate metadata86Template = AddressTemplate.of("/{selected.host}/{selected.server-config}");
        this.metadata86 = mbuiContext.metadataRegistry().lookup(metadata86Template);
        AddressTemplate metadata90Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/system-property=*");
        this.metadata90 = mbuiContext.metadataRegistry().lookup(metadata90Template);
        AddressTemplate metadata89Template = AddressTemplate.of("/{selected.host}/{selected.server-config}/path=*");
        this.metadata89 = mbuiContext.metadataRegistry().lookup(metadata89Template);
        this.expressionElements = new HashMap<>();

        serverConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.server.Server>("server-configuration-form", metadata86)
            .includeRuntime()
            .include("name")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("host"), 1)
            .include("group")
            .include("auto-start")
            .include("update-auto-start-with-server-status")
            .include("socket-binding-group")
            .include("socket-binding-port-offset")
            .include("socket-binding-default-interface")
            .include("status")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Server Configuration", metadata86Template.resolve(mbuiContext.statementContext()), changedValues, metadata86))
            .prepareReset(form -> resetSingletonForm("Server Configuration", metadata86Template.resolve(mbuiContext.statementContext()), form, metadata86))
            .build();
        serverInterfaceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-interface-form", metadata87)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Interface", name, metadata87Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata87);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Interface", name, metadata87Template.resolve(mbuiContext.statementContext(), name), form, metadata87);
            })
            .build();
        serverJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-jvm-form", metadata88)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("JVM", name, metadata88Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata88);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("JVM", name, metadata88Template.resolve(mbuiContext.statementContext(), name), form, metadata88);
            })
            .build();
        serverPathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-path-form", metadata89)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Path", name, metadata89Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata89);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Path", name, metadata89Template.resolve(mbuiContext.statementContext(), name), form, metadata89);
            })
            .build();
        serverSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-system-property-form", metadata90)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("System Property", name, metadata90Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata90);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("System Property", name, metadata90Template.resolve(mbuiContext.statementContext(), name), form, metadata90);
            })
            .build();

        serverInterfaceTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-interface-table", metadata87)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-interface-table", Ids.ADD), "Interface",
                metadata87Template, asList("inet-address"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Interface", metadata87Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        serverJvmTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-jvm-table", metadata88)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-jvm-table", Ids.ADD), "JVM",
                metadata88Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("JVM", metadata88Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        serverPathTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-path-table", metadata89)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-path-table", Ids.ADD), "Path",
                metadata89Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Path", metadata89Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "path")
            .build();
        serverSystemPropertyTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-system-property-table", metadata90)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-system-property-table", Ids.ADD), "System Property",
                metadata90Template, asList("value"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata90Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html258;
        HTMLElement serverConfigurationItemElement = section()
            .add(html258 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Server Configuration</h1><p>${metadata86.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serverConfigurationForm)
            .asElement();
        expressionElements.put("html258", html258);
        navigation.addPrimary("server-configuration-item", "Configuration", "pficon pficon-settings", serverConfigurationItemElement);
        HTMLElement html260;
        HTMLElement serverInterfaceItemElement = section()
            .add(html260 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Interfaces</h1><p>${metadata87.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serverInterfaceTable)
            .add(serverInterfaceForm)
            .asElement();
        expressionElements.put("html260", html260);
        navigation.addPrimary("server-interface-item", "Interfaces", "fa fa-exchange", serverInterfaceItemElement);
        HTMLElement html263;
        HTMLElement serverJvmItemElement = section()
            .add(html263 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>${metadata88.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serverJvmTable)
            .add(serverJvmForm)
            .asElement();
        expressionElements.put("html263", html263);
        navigation.addPrimary("server-jvm-item", "JVMs", "fa fa-coffee", serverJvmItemElement);
        HTMLElement html266;
        HTMLElement serverPathItemElement = section()
            .add(html266 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paths</h1><p>${metadata89.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serverPathTable)
            .add(serverPathForm)
            .asElement();
        expressionElements.put("html266", html266);
        navigation.addPrimary("server-path-item", "Paths", "fa fa-folder-open", serverPathItemElement);
        HTMLElement html269;
        HTMLElement serverSystemPropertyItemElement = section()
            .add(html269 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>${metadata90.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serverSystemPropertyTable)
            .add(serverSystemPropertyForm)
            .asElement();
        expressionElements.put("html269", html269);
        navigation.addPrimary("server-system-property-item", "System Properties", "fa fa-list-ul", serverSystemPropertyItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(serverConfigurationForm);
        registerAttachable(serverInterfaceTable);
        registerAttachable(serverInterfaceForm);
        registerAttachable(serverJvmTable);
        registerAttachable(serverJvmForm);
        registerAttachable(serverPathTable);
        registerAttachable(serverPathForm);
        registerAttachable(serverSystemPropertyTable);
        registerAttachable(serverSystemPropertyForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            serverInterfaceTable.bindForm(serverInterfaceForm);
            serverJvmTable.bindForm(serverJvmForm);
            serverPathTable.bindForm(serverPathForm);
            serverSystemPropertyTable.bindForm(serverSystemPropertyForm);

        TemplateUtil.replaceExpression(expressionElements.get("html258"), "${metadata86.getDescription().getDescription()}", String.valueOf(metadata86.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html260"), "${metadata87.getDescription().getDescription()}", String.valueOf(metadata87.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html263"), "${metadata88.getDescription().getDescription()}", String.valueOf(metadata88.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html266"), "${metadata89.getDescription().getDescription()}", String.valueOf(metadata89.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html269"), "${metadata90.getDescription().getDescription()}", String.valueOf(metadata90.getDescription().getDescription()));
    }
}
