package org.jboss.hal.client.runtime.group;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_ServerGroupView extends ServerGroupView {

    private final Metadata metadata93;
    private final Metadata metadata92;
    private final Metadata metadata94;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_ServerGroupView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata93Template = AddressTemplate.of("/{selected.group}/jvm=*");
        this.metadata93 = mbuiContext.metadataRegistry().lookup(metadata93Template);
        AddressTemplate metadata92Template = AddressTemplate.of("/{selected.group}");
        this.metadata92 = mbuiContext.metadataRegistry().lookup(metadata92Template);
        AddressTemplate metadata94Template = AddressTemplate.of("/{selected.group}/system-property=*");
        this.metadata94 = mbuiContext.metadataRegistry().lookup(metadata94Template);
        this.expressionElements = new HashMap<>();

        serverGroupConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.group.ServerGroup>("server-group-configuration-form", metadata92)
            .includeRuntime()
            .include("profile", "socket-binding-group", "socket-binding-port-offset", "socket-binding-default-interface", "management-subsystem-endpoint")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Server Group Configuration", metadata92Template.resolve(mbuiContext.statementContext()), changedValues, metadata92))
            .prepareReset(form -> resetSingletonForm("Server Group Configuration", metadata92Template.resolve(mbuiContext.statementContext()), form, metadata92))
            .build();
        serverGroupJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-group-jvm-form", metadata93)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("JVM", name, metadata93Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata93);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("JVM", name, metadata93Template.resolve(mbuiContext.statementContext(), name), form, metadata93);
            })
            .build();
        serverGroupSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("server-group-system-property-form", metadata94)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("System Property", name, metadata94Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata94);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("System Property", name, metadata94Template.resolve(mbuiContext.statementContext(), name), form, metadata94);
            })
            .build();

        serverGroupJvmTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-group-jvm-table", metadata93)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-group-jvm-table", Ids.ADD), "JVM",
                metadata93Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("JVM", metadata93Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .build();
        serverGroupSystemPropertyTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("server-group-system-property-table", metadata94)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("server-group-system-property-table", Ids.ADD), "System Property",
                metadata94Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata94Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> row.getName())
            .column("value")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html276;
        HTMLElement serverGroupConfigurationItemElement = section()
            .add(html276 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Server Group Configuration</h1><p>${metadata92.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serverGroupConfigurationForm)
            .asElement();
        expressionElements.put("html276", html276);
        navigation.addPrimary("server-group-configuration-item", "Configuration", "pficon pficon-settings", serverGroupConfigurationItemElement);
        HTMLElement html278;
        HTMLElement serverGroupJvmItemElement = section()
            .add(html278 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>${metadata93.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serverGroupJvmTable)
            .add(serverGroupJvmForm)
            .asElement();
        expressionElements.put("html278", html278);
        navigation.addPrimary("server-group-jvm-item", "JVMs", "fa fa-coffee", serverGroupJvmItemElement);
        HTMLElement html281;
        HTMLElement serverGroupSystemPropertyItemElement = section()
            .add(html281 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>${metadata94.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serverGroupSystemPropertyTable)
            .add(serverGroupSystemPropertyForm)
            .asElement();
        expressionElements.put("html281", html281);
        navigation.addPrimary("server-group-system-property-item", "System Properties", "fa fa-list-ul", serverGroupSystemPropertyItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(serverGroupConfigurationForm);
        registerAttachable(serverGroupJvmTable);
        registerAttachable(serverGroupJvmForm);
        registerAttachable(serverGroupSystemPropertyTable);
        registerAttachable(serverGroupSystemPropertyForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            serverGroupJvmTable.bindForm(serverGroupJvmForm);
            serverGroupSystemPropertyTable.bindForm(serverGroupSystemPropertyForm);

        TemplateUtil.replaceExpression(expressionElements.get("html276"), "${metadata92.getDescription().getDescription()}", String.valueOf(metadata92.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html278"), "${metadata93.getDescription().getDescription()}", String.valueOf(metadata93.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html281"), "${metadata94.getDescription().getDescription()}", String.valueOf(metadata94.getDescription().getDescription()));
    }
}
