/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.resource;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.forge.container.util.Assert;
import org.jboss.forge.container.util.OperatingSystemUtils;
import org.jboss.forge.resource.AbstractResource;
import org.jboss.forge.resource.DirectoryResource;
import org.jboss.forge.resource.FileResource;
import org.jboss.forge.resource.Resource;
import org.jboss.forge.resource.ResourceException;
import org.jboss.forge.resource.ResourceFactory;
import org.jboss.forge.resource.events.ResourceCreated;
import org.jboss.forge.resource.events.ResourceDeleted;
import org.jboss.forge.resource.events.ResourceModified;
import org.jboss.forge.resource.events.ResourceRenamed;
import org.jboss.forge.resource.events.TempResourceCreated;

public abstract class AbstractFileResource<T extends FileResource<T>>
extends AbstractResource<File>
implements FileResource<T> {
    protected File file;
    protected long lastModification;

    protected AbstractFileResource(ResourceFactory factory, File file) {
        super(factory, null);
        this.file = file;
        if (this.file != null) {
            this.lastModification = file.lastModified();
        }
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    public String toString() {
        return this.getFullyQualifiedName();
    }

    @Override
    public File getUnderlyingResourceObject() {
        return this.file;
    }

    @Override
    public InputStream getResourceInputStream() {
        try {
            return new BufferedInputStream(new FileInputStream(this.file));
        }
        catch (FileNotFoundException e) {
            throw new ResourceException("cannot obtain stream to file: file does not exist: " + this.file.getAbsolutePath());
        }
    }

    @Override
    public Resource<?> getParent() {
        return this.file.getParentFile() != null ? this.resourceFactory.create(DirectoryResource.class, this.file.getParentFile()) : null;
    }

    @Override
    public Resource<?> getChild(String name) {
        throw new ResourceException("[" + this.getClass().getSimpleName() + "] can have no children");
    }

    @Override
    public abstract Resource<File> createFrom(File var1);

    @Override
    public boolean exists() {
        return this.getUnderlyingResourceObject().exists();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isStale() {
        return this.lastModification != this.getUnderlyingResourceObject().lastModified();
    }

    @Override
    public void markUpToDate() {
        this.lastModification = this.getUnderlyingResourceObject().lastModified();
    }

    @Override
    public boolean mkdir() {
        if (this.file.mkdir()) {
            this.resourceFactory.fireEvent(new ResourceCreated(this));
            return true;
        }
        return false;
    }

    @Override
    public boolean mkdirs() {
        if (this.file.mkdirs()) {
            this.resourceFactory.fireEvent(new ResourceCreated(this));
            return true;
        }
        return false;
    }

    @Override
    public boolean delete() {
        return this.delete(false);
    }

    @Override
    public boolean delete(boolean recursive) {
        if (recursive) {
            if (AbstractFileResource._deleteRecursive(this.file, true)) {
                this.resourceFactory.fireEvent(new ResourceDeleted(this));
                return true;
            }
            return false;
        }
        if (this.file.listFiles() != null && this.file.listFiles().length != 0) {
            throw new RuntimeException("directory not empty");
        }
        if (OperatingSystemUtils.isWindows()) {
            System.gc();
        }
        if (this.file.delete()) {
            this.resourceFactory.fireEvent(new ResourceDeleted(this));
            return true;
        }
        return false;
    }

    @Override
    public void deleteOnExit() {
        this.file.deleteOnExit();
    }

    private static boolean _deleteRecursive(File file, boolean collect) {
        if (collect && OperatingSystemUtils.isWindows()) {
            System.gc();
        }
        if (file == null) {
            return false;
        }
        File[] children = file.listFiles();
        if (children != null) {
            for (File sf : children) {
                if (sf.isDirectory()) {
                    AbstractFileResource._deleteRecursive(sf, false);
                    continue;
                }
                if (sf.delete()) continue;
                throw new RuntimeException("failed to delete: " + sf.getAbsolutePath());
            }
        }
        return file.delete();
    }

    @Override
    public T setContents(String data) {
        if (data == null) {
            data = "";
        }
        return this.setContents(data.toCharArray());
    }

    @Override
    public T setContents(char[] data) {
        return this.setContents(new ByteArrayInputStream(new String(data).getBytes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T setContents(InputStream data) {
        Assert.notNull((Object)data, (String)"InputStream must not be null.");
        try {
            if (!this.exists()) {
                this.mkdirs();
                this.delete();
                if (!this.createNewFile()) {
                    throw new IOException("Failed to create file: " + this.file);
                }
            }
            this.file.delete();
            FileOutputStream out = new FileOutputStream(this.file);
            try {
                int len;
                byte[] buf = new byte[1024];
                while ((len = data.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
            }
            finally {
                if (data != null) {
                    data.close();
                }
                out.flush();
                ((OutputStream)out).close();
                if (OperatingSystemUtils.isWindows()) {
                    System.gc();
                }
            }
            this.resourceFactory.fireEvent(new ResourceModified(this));
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
        return (T)this;
    }

    @Override
    public boolean createNewFile() {
        try {
            if (this.file.mkdirs()) {
                this.file.delete();
            }
            if (this.file.createNewFile()) {
                this.resourceFactory.fireEvent(new ResourceCreated(this));
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    @Override
    public T createTempResource() {
        try {
            FileResource result = (FileResource)this.createFrom(File.createTempFile("forgetemp", ""));
            this.resourceFactory.fireEvent(new TempResourceCreated(result));
            return (T)result;
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    @Override
    public <R extends Resource<?>> R reify(Class<R> type) {
        R result = this.resourceFactory.create(type, this.file);
        if (type.isAssignableFrom(result.getClass())) {
            return result;
        }
        return null;
    }

    @Override
    public boolean renameTo(String pathspec) {
        return this.renameTo(new File(pathspec));
    }

    @Override
    public boolean renameTo(FileResource<?> target) {
        return this.renameTo((File)target.getUnderlyingResourceObject());
    }

    private boolean renameTo(File target) {
        File original = this.file.getAbsoluteFile();
        if (this.file.renameTo(target)) {
            this.resourceFactory.fireEvent(new ResourceRenamed(this, original.getAbsolutePath(), this.file.getAbsolutePath()));
            return true;
        }
        return false;
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    @Override
    public boolean isExecutable() {
        return this.file.canExecute() && !this.file.isDirectory();
    }

    @Override
    public boolean isReadable() {
        return this.file.canRead() && !this.file.isDirectory();
    }

    @Override
    public boolean isWritable() {
        return this.file.canWrite() && !this.file.isDirectory();
    }
}

