/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.jboss.forge.maven.resources.MavenDependencyResourceImpl;
import org.jboss.forge.maven.resources.MavenPomResource;
import org.jboss.forge.maven.resources.MavenProfileResourceImpl;
import org.jboss.forge.maven.resources.MavenRepositoryResourceImpl;
import org.jboss.forge.resource.AbstractFileResource;
import org.jboss.forge.resource.Resource;
import org.jboss.forge.resource.ResourceFactory;

public class MavenPomResourceImpl
extends AbstractFileResource<MavenPomResource>
implements MavenPomResource {
    private Model currentModel;

    public MavenPomResourceImpl(ResourceFactory factory) {
        super(factory, null);
    }

    public MavenPomResourceImpl(ResourceFactory factory, File file) {
        super(factory, file);
    }

    public Resource<?> getChild(String name) {
        List chidren = this.listResources();
        for (Resource child : chidren) {
            if (!child.getName().trim().equals(name)) continue;
            return child;
        }
        return null;
    }

    protected List<Resource<?>> doListResources() {
        ArrayList children = new ArrayList();
        this.listDependencies(children);
        this.listProfiles(children);
        this.listRepositories(children);
        return children;
    }

    private void listRepositories(List<Resource<?>> children) {
        List repositories = this.getCurrentModel().getRepositories();
        for (Repository repository : repositories) {
            children.add((Resource<?>)new MavenRepositoryResourceImpl(this.getResourceFactory(), this.parent, repository));
        }
    }

    private void listDependencies(List<Resource<?>> children) {
        Model model = this.getCurrentModel();
        for (Dependency dep : model.getDependencies()) {
            children.add((Resource<?>)new MavenDependencyResourceImpl((Resource<?>)this, dep));
        }
    }

    private void listProfiles(List<Resource<?>> children) {
        Model model = this.getCurrentModel();
        List profiles = model.getProfiles();
        for (Profile profile : profiles) {
            children.add((Resource<?>)new MavenProfileResourceImpl(this.getResourceFactory(), (Resource<?>)this, profile));
        }
    }

    public Model getCurrentModel() {
        this.initialize();
        return this.currentModel;
    }

    public Resource<File> createFrom(File file) {
        return new MavenPomResourceImpl(this.resourceFactory, file);
    }

    private void initialize() {
        if (this.currentModel == null) {
            try {
                MavenXpp3Reader reader = new MavenXpp3Reader();
                FileInputStream stream = new FileInputStream(this.getUnderlyingResourceObject());
                if (stream.available() > 0) {
                    this.currentModel = reader.read((InputStream)stream);
                }
                stream.close();
                this.currentModel.setPomFile(this.getUnderlyingResourceObject());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String toString() {
        return this.file.getName();
    }
}

