/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.javaee.servlet;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.forge.container.util.Streams;
import org.jboss.forge.dependencies.Dependency;
import org.jboss.forge.dependencies.builder.DependencyBuilder;
import org.jboss.forge.facets.FacetFactory;
import org.jboss.forge.facets.Faceted;
import org.jboss.forge.javaee.AbstractJavaEEFacet;
import org.jboss.forge.javaee.spec.ServletFacet;
import org.jboss.forge.projects.Project;
import org.jboss.forge.projects.dependencies.DependencyInstaller;
import org.jboss.forge.projects.facets.MetadataFacet;
import org.jboss.forge.projects.facets.WebResourceFacet;
import org.jboss.forge.resource.DirectoryResource;
import org.jboss.forge.resource.FileResource;
import org.jboss.forge.resource.Resource;
import org.jboss.forge.resource.ResourceFilter;
import org.jboss.shrinkwrap.descriptor.api.DescriptorImporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor;

public class ServletFacetImpl
extends AbstractJavaEEFacet
implements ServletFacet {
    private static final Dependency JAVAX_SERVLET_API = DependencyBuilder.create((String)"org.jboss.spec.javax.servlet:jboss-servlet-api_3.0_spec");
    @Inject
    private FacetFactory facetFactory;

    @Inject
    public ServletFacetImpl(DependencyInstaller installer) {
        super(installer);
    }

    @Override
    protected Map<Dependency, List<Dependency>> getRequiredDependencyOptions() {
        LinkedHashMap<Dependency, List<Dependency>> map = new LinkedHashMap<Dependency, List<Dependency>>();
        map.put(JAVAX_SERVLET_API, Arrays.asList(JAVAX_SERVLET_API));
        return map;
    }

    @Override
    public boolean isInstalled() {
        Project project = (Project)this.getOrigin();
        if (!project.hasFacet(WebResourceFacet.class)) {
            return false;
        }
        DirectoryResource webRoot = ((WebResourceFacet)project.getFacet(WebResourceFacet.class)).getWebRootDirectory();
        return webRoot.exists();
    }

    @Override
    public boolean install() {
        Project project;
        WebResourceFacet webFacet;
        DirectoryResource webRoot;
        if (!this.isInstalled() && !(webRoot = (webFacet = (WebResourceFacet)this.facetFactory.install(WebResourceFacet.class, (Faceted)(project = (Project)this.getOrigin()))).getWebRootDirectory()).exists()) {
            webRoot.mkdirs();
        }
        return super.install();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebAppDescriptor getConfig() {
        DescriptorImporter importer = Descriptors.importAs(WebAppDescriptor.class);
        FileResource<?> configFile = this.getConfigFile();
        InputStream inputStream = configFile.getResourceInputStream();
        try {
            WebAppDescriptor descriptor;
            WebAppDescriptor webAppDescriptor = descriptor = (WebAppDescriptor)importer.fromStream(inputStream);
            return webAppDescriptor;
        }
        finally {
            Streams.closeQuietly((Closeable)inputStream);
        }
    }

    public void saveConfig(WebAppDescriptor descriptor) {
        String output = descriptor.exportAsString();
        FileResource<?> configFile = this.getConfigFile();
        configFile.setContents(output);
    }

    public FileResource<?> getConfigFile() {
        Project project = (Project)this.getOrigin();
        DirectoryResource webRoot = ((WebResourceFacet)project.getFacet(WebResourceFacet.class)).getWebRootDirectory();
        FileResource child = (FileResource)webRoot.getChild("WEB-INF" + File.separator + "web.xml");
        if (!child.exists()) {
            String projectName = ((MetadataFacet)project.getFacet(MetadataFacet.class)).getProjectName();
            WebAppDescriptor unit = (WebAppDescriptor)((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).displayName(new String[]{projectName}).createSessionConfig().sessionTimeout(Integer.valueOf(30)).up();
            child.setContents(unit.exportAsString());
        }
        return child;
    }

    public List<Resource<?>> getResources() {
        DirectoryResource webRoot = ((WebResourceFacet)((Project)this.getOrigin()).getFacet(WebResourceFacet.class)).getWebRootDirectory();
        return this.listChildrenRecursively(webRoot);
    }

    private List<Resource<?>> listChildrenRecursively(DirectoryResource webRoot) {
        return this.listChildrenRecursively(webRoot, new ResourceFilter(){

            public boolean accept(Resource<?> resource) {
                return true;
            }
        });
    }

    public List<Resource<?>> getResources(ResourceFilter filter) {
        DirectoryResource webRoot = ((WebResourceFacet)((Project)this.getOrigin()).getFacet(WebResourceFacet.class)).getWebRootDirectory();
        return this.listChildrenRecursively(webRoot, filter);
    }

    private List<Resource<?>> listChildrenRecursively(DirectoryResource current, ResourceFilter filter) {
        ArrayList result = new ArrayList();
        List list = current.listResources();
        if (list != null) {
            for (Resource file : list) {
                if (file instanceof DirectoryResource) {
                    result.addAll(this.listChildrenRecursively((DirectoryResource)file, filter));
                }
                if (!filter.accept(file)) continue;
                result.add(file);
            }
        }
        return result;
    }
}

