/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.java.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.Annotation;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.ValuePair;
import org.jboss.forge.parser.java.impl.TypeImpl;
import org.jboss.forge.parser.java.impl.ValuePairImpl;
import org.jboss.forge.parser.java.source.AnnotationSource;
import org.jboss.forge.parser.java.source.AnnotationTargetSource;
import org.jboss.forge.parser.java.source.JavaSource;
import org.jboss.forge.parser.java.util.Assert;
import org.jboss.forge.parser.java.util.Strings;

public class AnnotationImpl<O extends JavaSource<O>, T>
implements AnnotationSource<O> {
    private static final String DEFAULT_VALUE = "value";
    private AnnotationTargetSource<O, T> parent = null;
    private AST ast = null;
    private org.eclipse.jdt.core.dom.Annotation annotation;

    public AnnotationImpl(AnnotationTargetSource<O, T> parent) {
        this(parent, AnnotationType.MARKER);
    }

    public AnnotationImpl(AnnotationTargetSource<O, T> parent, Object internal) {
        this.parent = parent;
        this.ast = ((ASTNode)parent.getInternal()).getAST();
        this.annotation = (org.eclipse.jdt.core.dom.Annotation)internal;
    }

    public AnnotationImpl(AnnotationTargetSource<O, T> parent, AnnotationType type) {
        this(parent, AnnotationImpl.createAnnotation(parent, type));
    }

    private static org.eclipse.jdt.core.dom.Annotation createAnnotation(AnnotationTargetSource<?, ?> parent, AnnotationType type) {
        AST ast = ((ASTNode)parent.getInternal()).getAST();
        switch (type) {
            case MARKER: {
                return ast.newMarkerAnnotation();
            }
            case SINGLE: {
                return ast.newSingleMemberAnnotation();
            }
            case NORMAL: {
                return ast.newNormalAnnotation();
            }
        }
        throw new IllegalArgumentException("Unknown annotation type: " + (Object)((Object)type));
    }

    public String getName() {
        return this.annotation.getTypeName().getFullyQualifiedName();
    }

    public String getQualifiedName() {
        return ((JavaSource)this.parent.getOrigin()).resolveType(this.getName());
    }

    public String getLiteralValue() throws IllegalStateException {
        String result = null;
        if (this.isSingleValue()) {
            SingleMemberAnnotation sm = (SingleMemberAnnotation)this.annotation;
            result = sm.getValue().toString();
        } else if (this.isNormal()) {
            List<ValuePair> values = this.getValues();
            for (ValuePair pair : values) {
                String name = pair.getName();
                if (!DEFAULT_VALUE.equals(name)) continue;
                result = pair.getLiteralValue();
                break;
            }
        }
        return result;
    }

    public String getLiteralValue(String name) {
        String result = null;
        if (this.isNormal()) {
            for (Object v : ((NormalAnnotation)this.annotation).values()) {
                MemberValuePair pair;
                if (!(v instanceof MemberValuePair) || !(pair = (MemberValuePair)v).getName().getFullyQualifiedName().equals(name)) continue;
                result = pair.getValue().toString();
                break;
            }
        } else if (DEFAULT_VALUE.equals(name) && this.isSingleValue()) {
            return this.getLiteralValue();
        }
        return result;
    }

    public List<ValuePair> getValues() {
        ArrayList<ValuePairImpl> result = new ArrayList<ValuePairImpl>();
        if (this.isNormal()) {
            for (Object v : ((NormalAnnotation)this.annotation).values()) {
                if (!(v instanceof MemberValuePair)) continue;
                MemberValuePair pair = (MemberValuePair)v;
                ValuePairImpl temp = new ValuePairImpl(pair.getName().getFullyQualifiedName(), pair.getValue().toString());
                result.add(temp);
            }
        } else if (this.isSingleValue()) {
            result.add(new ValuePairImpl(DEFAULT_VALUE, this.getLiteralValue()));
        }
        return Collections.unmodifiableList(result);
    }

    public String getStringValue() throws IllegalStateException {
        return Strings.unquote((String)this.getLiteralValue());
    }

    public String getStringValue(String name) {
        return Strings.unquote((String)this.getLiteralValue(name));
    }

    public boolean isMarker() {
        return this.annotation.isMarkerAnnotation();
    }

    public boolean isNormal() {
        return this.annotation.isNormalAnnotation();
    }

    public boolean isSingleValue() {
        return this.annotation.isSingleMemberAnnotation();
    }

    public AnnotationSource<O> removeAllValues() {
        this.convertTo(AnnotationType.MARKER);
        return this;
    }

    public AnnotationSource<O> removeValue(String name) {
        if (this.annotation.isNormalAnnotation()) {
            NormalAnnotation na = (NormalAnnotation)this.annotation;
            ArrayList<MemberValuePair> toBeRemoved = new ArrayList<MemberValuePair>();
            for (Object v : na.values()) {
                MemberValuePair pair;
                if (!(v instanceof MemberValuePair) || !(pair = (MemberValuePair)v).getName().toString().equals(name)) continue;
                toBeRemoved.add(pair);
            }
            na.values().removeAll(toBeRemoved);
            if (this.getLiteralValue() != null && this.getValues().size() == 1) {
                this.convertTo(AnnotationType.SINGLE);
            } else if (this.getValues().size() == 0) {
                this.convertTo(AnnotationType.MARKER);
            }
        } else if (this.annotation.isSingleMemberAnnotation()) {
            this.removeAllValues();
        }
        return this;
    }

    public AnnotationSource<O> setName(String className) {
        this.annotation.setTypeName(this.ast.newName(className));
        return this;
    }

    public AnnotationSource<O> setLiteralValue(String value) {
        Assert.notNull((Object)value, (String)"null not accepted");
        if (this.isMarker()) {
            this.convertTo(AnnotationType.SINGLE);
        }
        if (this.isSingleValue()) {
            SingleMemberAnnotation sa = (SingleMemberAnnotation)this.annotation;
            String stub = "@" + this.getName() + "(" + value + ") public class Stub { }";
            JavaClass temp = (JavaClass)JavaParser.parse(JavaClass.class, (String)stub);
            SingleMemberAnnotation anno = (SingleMemberAnnotation)((Annotation)temp.getAnnotations().get(0)).getInternal();
            Expression expression = anno.getValue();
            sa.setValue((Expression)ASTNode.copySubtree((AST)this.ast, (ASTNode)expression));
        } else {
            this.setLiteralValue(DEFAULT_VALUE, value);
        }
        return this;
    }

    public AnnotationSource<O> setLiteralValue(String name, String value) {
        Assert.notNull((Object)value, (String)"null not accepted");
        if (!this.isNormal() && !DEFAULT_VALUE.equals(name)) {
            this.convertTo(AnnotationType.NORMAL);
        } else if (!this.isSingleValue() && !this.isNormal() && DEFAULT_VALUE.equals(name)) {
            this.convertTo(AnnotationType.SINGLE);
        }
        if (this.isSingleValue() && DEFAULT_VALUE.equals(name)) {
            return this.setLiteralValue(value);
        }
        NormalAnnotation na = (NormalAnnotation)this.annotation;
        String stub = "@" + this.getName() + "(" + name + "=" + value + " ) public class Stub { }";
        JavaClass temp = (JavaClass)JavaParser.parse(JavaClass.class, (String)stub);
        NormalAnnotation anno = (NormalAnnotation)((Annotation)temp.getAnnotations().get(0)).getInternal();
        MemberValuePair mvp = (MemberValuePair)anno.values().get(0);
        List values = na.values();
        ListIterator<MemberValuePair> iter = values.listIterator();
        while (iter.hasNext()) {
            if (!((MemberValuePair)iter.next()).getName().getIdentifier().equals(name)) continue;
            iter.remove();
            break;
        }
        iter.add((MemberValuePair)ASTNode.copySubtree((AST)this.annotation.getAST(), (ASTNode)mvp));
        return this;
    }

    public AnnotationSource<O> setStringValue(String value) {
        return this.setLiteralValue(Strings.enquote((String)value));
    }

    public AnnotationSource<O> setStringValue(String name, String value) {
        return this.setLiteralValue(name, Strings.enquote((String)value));
    }

    public <E extends Enum<E>> E getEnumValue(Class<E> type) {
        String literalValue = this.getLiteralValue();
        return this.convertLiteralToEnum(type, literalValue);
    }

    public <E extends Enum<E>> E getEnumValue(Class<E> type, String name) {
        String literalValue = this.getLiteralValue(name);
        return this.convertLiteralToEnum(type, literalValue);
    }

    private <E extends Enum<E>> E convertLiteralToEnum(Class<E> type, String literalValue) {
        Enum[] constants;
        for (Enum inst : constants = (Enum[])type.getEnumConstants()) {
            String[] tokens = literalValue.split("\\.");
            if (tokens.length > 1) {
                literalValue = tokens[tokens.length - 1];
            }
            if (!inst.name().equals(literalValue)) continue;
            return (E)inst;
        }
        return null;
    }

    public AnnotationSource<O> setEnumValue(String name, Enum<?> value) {
        return this.setEnumArrayValue(name, value);
    }

    public AnnotationSource<O> setEnumValue(Enum<?> ... values) {
        return this.setEnumArrayValue(values);
    }

    public AnnotationSource<O> setEnumArrayValue(Enum<?> ... values) {
        return this.setEnumArrayValue(DEFAULT_VALUE, values);
    }

    public AnnotationSource<O> setEnumArrayValue(String name, Enum<?> ... values) {
        Assert.notNull(values, (String)"null array not accepted");
        ArrayList<String> literals = new ArrayList<String>();
        for (Enum<?> value : values) {
            Assert.notNull(value, (String)"null value not accepted");
            this.getOrigin().addImport(value.getDeclaringClass());
            literals.add(value.getDeclaringClass().getSimpleName() + "." + value.name());
        }
        return this.setLiteralValue(name, literals.size() == 1 ? (String)literals.get(0) : String.format("{%s}", Strings.join(literals, (String)",")));
    }

    public O getOrigin() {
        return (O)((JavaSource)this.parent.getOrigin());
    }

    public Object getInternal() {
        return this.annotation;
    }

    public String toString() {
        return this.annotation.toString();
    }

    protected void replace(org.eclipse.jdt.core.dom.Annotation oldNode, org.eclipse.jdt.core.dom.Annotation newNode) {
        List modifiers;
        ASTNode parentNode = oldNode.getParent();
        if (parentNode instanceof BodyDeclaration) {
            modifiers = ((BodyDeclaration)parentNode).modifiers();
        } else if (parentNode instanceof SingleVariableDeclaration) {
            modifiers = ((SingleVariableDeclaration)parentNode).modifiers();
        } else {
            throw new IllegalStateException("Cannot handle annotations attached to " + parentNode);
        }
        int pos = modifiers.indexOf(this.annotation);
        if (pos >= 0) {
            modifiers.set(pos, newNode);
        }
    }

    private void convertTo(AnnotationType type) {
        String value = this.getLiteralValue();
        AnnotationImpl<O, T> na = new AnnotationImpl<O, T>(this.parent, type);
        na.setName(this.getName());
        this.replace(this.annotation, na.annotation);
        this.annotation = na.annotation;
        if (AnnotationType.MARKER != type && value != null) {
            this.setLiteralValue(value);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotation == null ? 0 : this.annotation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationImpl other = (AnnotationImpl)obj;
        return !(this.annotation == null ? other.annotation != null : !this.annotation.equals((Object)other.annotation));
    }

    public AnnotationSource<O> setAnnotationValue() {
        if (this.isMarker()) {
            this.convertTo(AnnotationType.SINGLE);
        }
        if (this.isSingleValue()) {
            Nested result = new Nested(this);
            ((SingleMemberAnnotation)this.annotation).setValue((Expression)result.getInternal());
            return result;
        }
        return this.setAnnotationValue(DEFAULT_VALUE);
    }

    public AnnotationSource<O> setAnnotationValue(String name) {
        if (!this.isNormal() && DEFAULT_VALUE.equals(name)) {
            return this.setAnnotationValue();
        }
        if (!this.isNormal()) {
            this.convertTo(AnnotationType.NORMAL);
        }
        Nested result = new Nested(this);
        String stub = "@" + this.getName() + "(" + name + "= 0 ) public class Stub { }";
        JavaClass temp = (JavaClass)JavaParser.parse(JavaClass.class, (String)stub);
        NormalAnnotation anno = (NormalAnnotation)((Annotation)temp.getAnnotations().get(0)).getInternal();
        MemberValuePair mvp = (MemberValuePair)anno.values().get(0);
        List values = ((NormalAnnotation)this.annotation).values();
        ListIterator<MemberValuePair> iter = values.listIterator();
        while (iter.hasNext()) {
            if (!((MemberValuePair)iter.next()).getName().getIdentifier().equals(name)) continue;
            iter.remove();
            break;
        }
        MemberValuePair mvpCopy = (MemberValuePair)ASTNode.copySubtree((AST)this.annotation.getAST(), (ASTNode)mvp);
        mvpCopy.setValue((Expression)result.getInternal());
        iter.add(mvpCopy);
        return result;
    }

    public AnnotationSource<O> getAnnotationValue() {
        SingleMemberAnnotation single;
        Expression value;
        if (this.isSingleValue() && (value = (single = (SingleMemberAnnotation)this.annotation).getValue()) instanceof org.eclipse.jdt.core.dom.Annotation) {
            return new Nested(this, value);
        }
        if (this.isNormal()) {
            return this.getAnnotationValue(DEFAULT_VALUE);
        }
        return null;
    }

    public AnnotationSource<O> getAnnotationValue(String name) {
        if (this.isNormal()) {
            NormalAnnotation normal = (NormalAnnotation)this.annotation;
            List values = normal.values();
            for (MemberValuePair memberValuePair : values) {
                if (!Strings.areEqual((String)name, (String)memberValuePair.getName().getIdentifier())) continue;
                return new Nested(this, memberValuePair.getValue());
            }
        }
        if (this.isSingleValue() && DEFAULT_VALUE.equals(name)) {
            return this.getAnnotationValue();
        }
        return null;
    }

    public <E extends Enum<E>> E[] getEnumArrayValue(Class<E> type) {
        return this.getEnumArrayValue(type, DEFAULT_VALUE);
    }

    public <E extends Enum<E>> E[] getEnumArrayValue(Class<E> type, String name) {
        E instance;
        E expr = this.getElementValueExpression(name);
        if (expr instanceof ArrayInitializer) {
            ArrayList<E> results = new ArrayList<E>();
            List arrayElements = ((ArrayInitializer)expr).expressions();
            for (Expression arrayElement : arrayElements) {
                E instance2 = this.convertLiteralToEnum(type, arrayElement.toString());
                results.add(instance2);
            }
            Enum[] result = (Enum[])Array.newInstance(type, results.size());
            return results.toArray(result);
        }
        if (expr != null && type.isInstance(instance = this.convertLiteralToEnum(type, expr.toString()))) {
            Enum[] result = (Enum[])Array.newInstance(type, 1);
            result[0] = instance;
            return result;
        }
        return null;
    }

    public Class<?> getClassValue() {
        return this.getClassValue(DEFAULT_VALUE);
    }

    public Class<?> getClassValue(String name) {
        TypeLiteral typeLiteral = (TypeLiteral)this.getElementValueExpression(name);
        return this.resolveTypeLiteral(typeLiteral);
    }

    public Class<?>[] getClassArrayValue() {
        return this.getClassArrayValue(DEFAULT_VALUE);
    }

    public Class<?>[] getClassArrayValue(String name) {
        Object expr = this.getElementValueExpression(name);
        if (expr instanceof ArrayInitializer) {
            ArrayList result = new ArrayList();
            List arrayElements = ((ArrayInitializer)expr).expressions();
            for (Expression expression : arrayElements) {
                Class<?> type = this.resolveTypeLiteral((TypeLiteral)expression);
                result.add(type);
            }
            return result.toArray(new Class[result.size()]);
        }
        if (expr instanceof TypeLiteral) {
            return new Class[]{this.resolveTypeLiteral((TypeLiteral)expr)};
        }
        return null;
    }

    public AnnotationSource<O> setClassValue(String name, Class<?> value) {
        Assert.notNull(value, (String)"null not accepted");
        if (!value.isPrimitive()) {
            this.getOrigin().addImport(value);
        }
        return this.setLiteralValue(name, value.getSimpleName() + ".class");
    }

    public AnnotationSource<O> setClassValue(Class<?> value) {
        return this.setClassValue(DEFAULT_VALUE, value);
    }

    public AnnotationSource<O> setClassArrayValue(Class<?> ... values) {
        return this.setClassArrayValue(DEFAULT_VALUE, values);
    }

    public AnnotationSource<O> setClassArrayValue(String name, Class<?> ... values) {
        Assert.notNull(values, (String)"null array not accepted");
        ArrayList<String> literals = new ArrayList<String>();
        for (Class<?> value : values) {
            Assert.notNull(value, (String)"null value not accepted");
            if (!value.isPrimitive()) {
                this.getOrigin().addImport(value);
            }
            literals.add(value.getSimpleName() + ".class");
        }
        return this.setLiteralValue(name, literals.size() == 1 ? (String)literals.get(0) : String.format("{%s}", Strings.join(literals, (String)",")));
    }

    private <E extends Expression> E getElementValueExpression(String name) {
        if (this.isSingleValue() && DEFAULT_VALUE.equals(name)) {
            Expression result = ((SingleMemberAnnotation)this.annotation).getValue();
            return (E)result;
        }
        if (this.isNormal()) {
            for (Object v : ((NormalAnnotation)this.annotation).values()) {
                MemberValuePair pair;
                if (!(v instanceof MemberValuePair) || !(pair = (MemberValuePair)v).getName().getFullyQualifiedName().equals(name)) continue;
                Expression result = pair.getValue();
                return (E)result;
            }
        }
        return null;
    }

    private Class<?> resolveTypeLiteral(TypeLiteral typeLiteral) {
        TypeImpl<O> type = new TypeImpl<O>(this.getOrigin(), typeLiteral.getType());
        if (type.isPrimitive()) {
            Class[] primitiveTypes;
            for (Class c : primitiveTypes = new Class[]{Boolean.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}) {
                if (!c.getSimpleName().equals(type.getName())) continue;
                return c;
            }
            return null;
        }
        String classname = type.getQualifiedName();
        try {
            return Class.forName(this.getOrigin().resolveType(classname));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static enum AnnotationType {
        MARKER,
        SINGLE,
        NORMAL;

    }

    private class Nested
    extends AnnotationImpl<O, T> {
        Nested(AnnotationImpl<O, T> owner) {
            super(owner.parent);
        }

        Nested(AnnotationImpl<O, T> owner, Object internal) {
            super(owner.parent, internal);
        }

        @Override
        protected void replace(org.eclipse.jdt.core.dom.Annotation oldNode, org.eclipse.jdt.core.dom.Annotation newNode) {
            if (oldNode.getParent() instanceof SingleMemberAnnotation) {
                ((SingleMemberAnnotation)oldNode.getParent()).setValue((Expression)newNode);
            } else {
                ((MemberValuePair)oldNode.getParent()).setValue((Expression)newNode);
            }
        }
    }
}

