/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.java.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jface.text.Document;
import org.jboss.forge.parser.java.GenericCapable;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.impl.AbstractJavaSourceMemberHolder;

public abstract class AbstractGenericCapableJavaSource<O extends JavaSource<O>>
extends AbstractJavaSourceMemberHolder<O>
implements GenericCapable<O> {
    public AbstractGenericCapableJavaSource(JavaSource<?> enclosingType, Document document, CompilationUnit unit, BodyDeclaration declaration) {
        super(enclosingType, document, unit, declaration);
    }

    public List<String> getGenericTypes() {
        ArrayList<String> result = new ArrayList<String>();
        TypeDeclaration type = (TypeDeclaration)this.body;
        List typeParameters = type.typeParameters();
        if (typeParameters != null) {
            for (TypeParameter typeParameter : typeParameters) {
                result.add(typeParameter.getName().getIdentifier());
            }
        }
        return Collections.unmodifiableList(result);
    }

    public O addGenericType(String genericType) {
        TypeDeclaration type = (TypeDeclaration)this.body;
        TypeParameter tp2 = this.unit.getAST().newTypeParameter();
        tp2.setName(this.unit.getAST().newSimpleName(genericType));
        type.typeParameters().add(tp2);
        return (O)this;
    }

    public O removeGenericType(String genericType) {
        TypeDeclaration type = (TypeDeclaration)this.body;
        List typeParameters = type.typeParameters();
        if (typeParameters != null) {
            Iterator it = typeParameters.iterator();
            while (it.hasNext()) {
                TypeParameter typeParameter = (TypeParameter)it.next();
                if (!typeParameter.getName().getIdentifier().equals(genericType)) continue;
                it.remove();
            }
        }
        return (O)this;
    }
}

