/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.java.impl;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.Document;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.Method;
import org.jboss.forge.parser.java.SourceType;
import org.jboss.forge.parser.java.ast.ModifierAccessor;
import org.jboss.forge.parser.java.impl.AbstractGenericCapableJavaSource;
import org.jboss.forge.parser.java.util.Types;

public class JavaClassImpl
extends AbstractGenericCapableJavaSource<JavaClass>
implements JavaClass {
    private final ModifierAccessor modifiers = new ModifierAccessor();

    public JavaClassImpl(JavaSource<?> enclosingType, Document document, CompilationUnit unit, BodyDeclaration body) {
        super(enclosingType, document, unit, body);
    }

    @Override
    protected JavaClass updateTypeNames(String newName) {
        for (Method m : this.getMethods()) {
            if (!m.isConstructor()) continue;
            m.setConstructor(false);
            m.setConstructor(true);
        }
        return this;
    }

    public boolean isAbstract() {
        return this.modifiers.hasModifier((ASTNode)this.getBodyDeclaration(), Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
    }

    public JavaClass setAbstract(boolean abstrct) {
        if (abstrct) {
            this.modifiers.addModifier((ASTNode)this.getBodyDeclaration(), Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
        } else {
            this.modifiers.removeModifier((ASTNode)this.getBodyDeclaration(), Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
        }
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.toString() == null ? 0 : this.unit.toString().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.toString().equals(obj.toString());
    }

    public String getSuperType() {
        Object superType = this.getBodyDeclaration().getStructuralProperty((StructuralPropertyDescriptor)TypeDeclaration.SUPERCLASS_TYPE_PROPERTY);
        if (superType == null) {
            superType = Object.class.getName();
        }
        return this.resolveType(superType.toString());
    }

    public JavaClass setSuperType(JavaClass type) {
        return this.setSuperType(type.getQualifiedName());
    }

    public JavaClass setSuperType(Class<?> type) {
        if (type.isAnnotation() || type.isEnum() || type.isInterface() || type.isPrimitive()) {
            throw new IllegalArgumentException("Super-type must be a Class type, but was [" + type.getName() + "]");
        }
        return this.setSuperType(type.getName());
    }

    public JavaClass setSuperType(String type) {
        if (type == null || type.trim().isEmpty()) {
            this.getBodyDeclaration().setStructuralProperty((StructuralPropertyDescriptor)TypeDeclaration.SUPERCLASS_TYPE_PROPERTY, null);
        } else if (Types.isGeneric((String)type)) {
            String typeD = Types.stripGenerics((String)type);
            String sympleTypeDName = Types.toSimpleName((String)typeD);
            String typesGeneric = Types.getGenericsTypeParameter((String)type);
            ParameterizedType pt = this.body.getAST().newParameterizedType((Type)this.body.getAST().newSimpleType((Name)this.body.getAST().newSimpleName(sympleTypeDName)));
            if (!this.hasImport(typeD) && Types.isQualified((String)typeD)) {
                this.addImport(typeD);
            }
            for (String typeP : typesGeneric.split(",")) {
                pt.typeArguments().add(this.body.getAST().newSimpleType((Name)this.body.getAST().newSimpleName(Types.toSimpleName((String)typeP.trim()))));
                if (this.hasImport(typeP) || !Types.isQualified((String)typeP)) continue;
                this.addImport(typeP);
            }
            this.getBodyDeclaration().setStructuralProperty((StructuralPropertyDescriptor)TypeDeclaration.SUPERCLASS_TYPE_PROPERTY, (Object)pt);
        } else {
            SimpleType simpleType = this.body.getAST().newSimpleType((Name)this.body.getAST().newSimpleName(Types.toSimpleName((String)type)));
            this.getBodyDeclaration().setStructuralProperty((StructuralPropertyDescriptor)TypeDeclaration.SUPERCLASS_TYPE_PROPERTY, (Object)simpleType);
            if (!this.hasImport(type) && Types.isQualified((String)type)) {
                this.addImport(type);
            }
        }
        return this;
    }

    public SourceType getSourceType() {
        return SourceType.CLASS;
    }
}

