/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.java.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.jboss.forge.parser.java.Annotation;
import org.jboss.forge.parser.java.AnnotationTarget;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.impl.AnnotationImpl;
import org.jboss.forge.parser.java.util.Types;

public class AnnotationAccessor<O extends JavaSource<O>, T> {
    public Annotation<O> addAnnotation(AnnotationTarget<O, T> target, BodyDeclaration body) {
        return this.addAnnotation(target, body.modifiers());
    }

    public Annotation<O> addAnnotation(AnnotationTarget<O, T> target, SingleVariableDeclaration variableDeclaration) {
        return this.addAnnotation(target, variableDeclaration.modifiers());
    }

    private Annotation<O> addAnnotation(AnnotationTarget<O, T> target, List<?> modifiers) {
        ListIterator<?> iter = modifiers.listIterator();
        while (iter.hasNext() && ((IExtendedModifier)iter.next()).isAnnotation()) {
        }
        if (iter.hasPrevious() && ((IExtendedModifier)iter.previous()).isAnnotation()) {
            iter.next();
        }
        AnnotationImpl<O, T> annotation = new AnnotationImpl<O, T>(target);
        iter.add((IExtendedModifier)annotation.getInternal());
        return annotation;
    }

    public Annotation<O> addAnnotation(AnnotationTarget<O, T> target, BodyDeclaration body, Class<?> clazz) {
        return this.addAnnotation(target, body.modifiers(), clazz.getName());
    }

    public Annotation<O> addAnnotation(AnnotationTarget<O, T> target, SingleVariableDeclaration variableDeclaration, Class<?> clazz) {
        return this.addAnnotation(target, variableDeclaration.modifiers(), clazz.getName());
    }

    public Annotation<O> addAnnotation(AnnotationTarget<O, T> target, BodyDeclaration body, String className) {
        return this.addAnnotation(target, body.modifiers(), className);
    }

    public Annotation<O> addAnnotation(AnnotationTarget<O, T> target, SingleVariableDeclaration variableDeclaration, String className) {
        return this.addAnnotation(target, variableDeclaration.modifiers(), className);
    }

    private Annotation<O> addAnnotation(AnnotationTarget<O, T> target, List<?> modifiers, String className) {
        if (!((JavaSource)target.getOrigin()).hasImport(className) && Types.isQualified((String)className)) {
            ((JavaSource)target.getOrigin()).addImport(className);
        }
        return this.addAnnotation(target, modifiers).setName(Types.toSimpleName((String)className));
    }

    public List<Annotation<O>> getAnnotations(AnnotationTarget<O, T> target, BodyDeclaration body) {
        return this.getAnnotations(target, body.modifiers());
    }

    public List<Annotation<O>> getAnnotations(AnnotationTarget<O, T> target, SingleVariableDeclaration variableDeclaration) {
        return this.getAnnotations(target, variableDeclaration.modifiers());
    }

    private List<Annotation<O>> getAnnotations(AnnotationTarget<O, T> target, List<?> modifiers) {
        ArrayList<AnnotationImpl<O, T>> result = new ArrayList<AnnotationImpl<O, T>>();
        for (Object object : modifiers) {
            if (!(object instanceof org.eclipse.jdt.core.dom.Annotation)) continue;
            AnnotationImpl<O, T> annotation = new AnnotationImpl<O, T>(target, object);
            result.add(annotation);
        }
        return Collections.unmodifiableList(result);
    }

    public <E extends AnnotationTarget<O, T>> E removeAnnotation(E target, BodyDeclaration body, Annotation<O> annotation) {
        return this.removeAnnotation(target, body.modifiers(), annotation);
    }

    public <E extends AnnotationTarget<O, T>> E removeAnnotation(E target, SingleVariableDeclaration variableDeclaration, Annotation<O> annotation) {
        return this.removeAnnotation(target, variableDeclaration.modifiers(), annotation);
    }

    private <E extends AnnotationTarget<O, T>> E removeAnnotation(E target, List<?> modifiers, Annotation<O> annotation) {
        for (Object object : modifiers) {
            if (!object.equals(annotation.getInternal())) continue;
            modifiers.remove(object);
            break;
        }
        return target;
    }

    public <E extends AnnotationTarget<O, T>> boolean hasAnnotation(E target, BodyDeclaration body, String type) {
        return this.hasAnnotation(target, body.modifiers(), type);
    }

    public <E extends AnnotationTarget<O, T>> boolean hasAnnotation(E target, SingleVariableDeclaration variableDeclaration, String type) {
        return this.hasAnnotation(target, variableDeclaration.modifiers(), type);
    }

    private <E extends AnnotationTarget<O, T>> boolean hasAnnotation(E target, List<?> modifiers, String type) {
        for (Object object : modifiers) {
            AnnotationImpl annotation;
            String annotationType;
            if (!(object instanceof org.eclipse.jdt.core.dom.Annotation) || !Types.areEquivalent((String)type, (String)(annotationType = (annotation = new AnnotationImpl(target, object)).getName()))) continue;
            return true;
        }
        return false;
    }

    public Annotation<O> getAnnotation(AnnotationTarget<O, T> target, BodyDeclaration body, Class<? extends java.lang.annotation.Annotation> type) {
        return this.getAnnotation(target, body.modifiers(), type.getName());
    }

    public Annotation<O> getAnnotation(AnnotationTarget<O, T> target, SingleVariableDeclaration variableDeclaration, Class<? extends java.lang.annotation.Annotation> type) {
        return this.getAnnotation(target, variableDeclaration.modifiers(), type.getName());
    }

    public Annotation<O> getAnnotation(AnnotationTarget<O, T> target, BodyDeclaration body, String type) {
        return this.getAnnotation(target, body.modifiers(), type);
    }

    public Annotation<O> getAnnotation(AnnotationTarget<O, T> target, SingleVariableDeclaration variableDeclaration, String type) {
        return this.getAnnotation(target, variableDeclaration.modifiers(), type);
    }

    private Annotation<O> getAnnotation(AnnotationTarget<O, T> target, List<?> modifiers, String type) {
        List<Annotation<O>> annotations = this.getAnnotations(target, modifiers);
        for (Annotation<O> annotation : annotations) {
            if (!Types.areEquivalent((String)type, (String)annotation.getName())) continue;
            return annotation;
        }
        return null;
    }
}

