/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.errai.security.keycloak;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.enterprise.context.SessionScoped;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.bus.server.api.RpcContext;
import org.jboss.errai.security.keycloak.extension.Filtered;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.RoleImpl;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.jboss.errai.security.shared.exception.AlreadyLoggedInException;
import org.jboss.errai.security.shared.exception.AuthenticationException;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AddressClaimSet;

@Service
@SessionScoped
public class KeycloakAuthenticationService
implements AuthenticationService,
Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    @Filtered
    private AuthenticationService wrappedAuthService;
    private User keycloakUser;
    private KeycloakSecurityContext keycloakSecurityContext;

    public User login(String username, String password) {
        if (!this.keycloakIsLoggedIn()) {
            return this.wrappedAuthService.login(username, password);
        }
        throw new AlreadyLoggedInException("Already logged in through Keycloak.");
    }

    public boolean isLoggedIn() {
        return this.keycloakIsLoggedIn() || this.wrappedAuthService.isLoggedIn();
    }

    private boolean keycloakIsLoggedIn() {
        return this.keycloakSecurityContext != null && this.keycloakSecurityContext.getToken() != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void logout() {
        if (this.keycloakIsLoggedIn()) {
            this.keycloakLogout();
            try {
                if (RpcContext.getMessage() == null) return;
                ((HttpServletRequest)RpcContext.getServletRequest()).logout();
                return;
            }
            catch (ServletException e) {
                throw new AuthenticationException("An error occurred while attempting to log out of Keycloak.");
            }
        } else {
            if (!this.wrappedAuthService.isLoggedIn()) return;
            this.wrappedAuthService.logout();
        }
    }

    private void keycloakLogout() {
        this.setSecurityContext(null);
    }

    public User getUser() {
        if (this.keycloakIsLoggedIn()) {
            return this.getKeycloakUser();
        }
        if (this.wrappedAuthService.isLoggedIn()) {
            return this.wrappedAuthService.getUser();
        }
        return User.ANONYMOUS;
    }

    private User getKeycloakUser() {
        if (!this.keycloakIsLoggedIn()) {
            throw new IllegalStateException("Cannot call getKeycloakUser if not logged in through Keycloak.");
        }
        if (this.keycloakUser == null) {
            this.keycloakUser = this.createKeycloakUser(this.keycloakSecurityContext.getToken());
        }
        return this.keycloakUser;
    }

    protected User createKeycloakUser(AccessToken accessToken) {
        UserImpl user = new UserImpl(accessToken.getPreferredUsername(), this.createRoles(accessToken));
        Collection<KeycloakProperty> properties = this.getKeycloakUserProperties(accessToken);
        for (KeycloakProperty property : properties) {
            if (!property.hasValue()) continue;
            user.setProperty(property.name, property.value);
        }
        return user;
    }

    private Collection<KeycloakProperty> getKeycloakUserProperties(AccessToken accessToken) {
        ArrayList<KeycloakProperty> properties = new ArrayList<KeycloakProperty>();
        properties.add(new KeycloakProperty("org.jboss.errai.security.FIRST_NAME", accessToken.getGivenName()));
        properties.add(new KeycloakProperty("org.jboss.errai.security.LAST_NAME", accessToken.getFamilyName()));
        properties.add(new KeycloakProperty("org.jboss.errai.security.EMAIL", accessToken.getEmail()));
        properties.add(new KeycloakProperty("birthdate", accessToken.getBirthdate()));
        properties.add(new KeycloakProperty("gender", accessToken.getGender()));
        properties.add(new KeycloakProperty("locale", accessToken.getLocale()));
        properties.add(new KeycloakProperty("middle-name", accessToken.getMiddleName()));
        properties.add(new KeycloakProperty("name", accessToken.getName()));
        properties.add(new KeycloakProperty("nickname", accessToken.getNickName()));
        properties.add(new KeycloakProperty("phonenumber", accessToken.getPhoneNumber()));
        properties.add(new KeycloakProperty("picture", accessToken.getPicture()));
        properties.add(new KeycloakProperty("preferred-username", accessToken.getPreferredUsername()));
        properties.add(new KeycloakProperty("profile", accessToken.getProfile()));
        properties.add(new KeycloakProperty("subject", accessToken.getSubject()));
        properties.add(new KeycloakProperty("website", accessToken.getWebsite()));
        properties.add(new KeycloakProperty("zone-info", accessToken.getZoneinfo()));
        properties.add(new KeycloakProperty("email-verified", String.valueOf(accessToken.getEmailVerified())));
        properties.add(new KeycloakProperty("phonenumber-verified", String.valueOf(accessToken.getPhoneNumberVerified())));
        AddressClaimSet address = accessToken.getAddress();
        if (address != null) {
            properties.add(new KeycloakProperty("country", accessToken.getAddress().getCountry()));
            properties.add(new KeycloakProperty("formatted-address", accessToken.getAddress().getFormattedAddress()));
            properties.add(new KeycloakProperty("locality", accessToken.getAddress().getLocality()));
            properties.add(new KeycloakProperty("postal-code", accessToken.getAddress().getPostalCode()));
            properties.add(new KeycloakProperty("region", accessToken.getAddress().getRegion()));
            properties.add(new KeycloakProperty("street-address", accessToken.getAddress().getStreetAddress()));
        }
        return properties;
    }

    private Collection<? extends Role> createRoles(AccessToken accessToken) {
        AccessToken.Access realmAccess;
        HashSet roleNames = new HashSet();
        AccessToken.Access access = accessToken.getResourceAccess(accessToken.getIssuedFor());
        if (access != null && access.getRoles() != null) {
            roleNames.addAll(access.getRoles());
        }
        if ((realmAccess = accessToken.getRealmAccess()) != null && realmAccess.getRoles() != null) {
            roleNames.addAll(realmAccess.getRoles());
        }
        ArrayList<RoleImpl> roles = new ArrayList<RoleImpl>(roleNames.size());
        for (String roleName : roleNames) {
            roles.add(new RoleImpl(roleName));
        }
        return roles;
    }

    void setSecurityContext(KeycloakSecurityContext keycloakSecurityContext) {
        if (this.wrappedAuthService.isLoggedIn() && keycloakSecurityContext != null) {
            throw new AlreadyLoggedInException("Logged in as " + this.wrappedAuthService.getUser());
        }
        this.keycloakSecurityContext = keycloakSecurityContext;
        this.keycloakUser = null;
    }

    private static class KeycloakProperty {
        final String name;
        final String value;

        KeycloakProperty(String name, String value) {
            this.name = name;
            this.value = value;
        }

        boolean hasValue() {
            return this.value != null;
        }
    }
}

