/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.errai.security.keycloak.extension;

import java.lang.annotation.Annotation;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.apache.deltaspike.core.util.metadata.builder.AnnotatedTypeBuilder;
import org.jboss.errai.security.keycloak.KeycloakAuthenticationService;
import org.jboss.errai.security.keycloak.extension.Wrapped;
import org.jboss.errai.security.shared.service.AuthenticationService;

public class AuthenticationServiceWrapperExtension
implements Extension {
    private final Wrapped wrapped = new Wrapped(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return Wrapped.class;
        }
    };

    public <T> void processAuthenticationServiceTypes(@Observes ProcessAnnotatedType<T> processedAnnotatedType) {
        Class type = processedAnnotatedType.getAnnotatedType().getJavaClass();
        if (this.isNonKeycloakAuthenticationService(type)) {
            processedAnnotatedType.setAnnotatedType(new AnnotatedTypeBuilder().readFromType(processedAnnotatedType.getAnnotatedType()).removeFromClass(Default.class).addToClass((Annotation)this.wrapped).create());
        }
    }

    private <T> boolean isNonKeycloakAuthenticationService(Class<T> type) {
        return AuthenticationService.class.isAssignableFrom(type) && !KeycloakAuthenticationService.class.isAssignableFrom(type);
    }
}

