/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.errai.security.keycloak;

import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletResponse;
import org.jboss.errai.security.keycloak.KeycloakAuthenticationService;
import org.keycloak.KeycloakSecurityContext;

@WebFilter(filterName="ErraiLoginRedirectFilter")
public class LoginRedirectFilter
implements Filter {
    public static final String REDIRECT_PARAM_NAME = "redirectLocation";
    private String redirectLocation;
    @Inject
    private KeycloakAuthenticationService keycloakAuthService;

    public void init(FilterConfig filterConfig) throws ServletException {
        String redirectParam = filterConfig.getInitParameter(REDIRECT_PARAM_NAME);
        this.redirectLocation = filterConfig.getServletContext().getContextPath();
        if (redirectParam != null) {
            this.redirectLocation = this.redirectLocation + redirectParam;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        this.keycloakAuthService.setSecurityContext((KeycloakSecurityContext)request.getAttribute(KeycloakSecurityContext.class.getName()));
        httpResponse.sendRedirect(this.redirectLocation);
    }

    public void destroy() {
    }
}

