/*
 * Copyright (C) 2015 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.errai.ioc.client.container;

import javax.inject.Named;

import jsinterop.annotations.JsType;

/**
 * Contract for providing managed beans across different scripts.
 * Implementations of this interface are code-generated by Errai IOC.
 *
 * @author Christian Sadilek <csadilek@redhat.com>
 * @author Max Barkley <mbarkley@redhat.com>
 */
@JsType
public interface JsTypeProvider<T> {

  /**
   * Returns a managed bean instance.
   */
  T getInstance();

  /**
   * Returns the name specified by {@link Named} or else null.
   */
  String getName();

  /**
   * Returns the name of the {@link Factory} that generates this bean, or else null.
   */
  String getFactoryName();
}
