/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.errai.cdi.server.gwt;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.spi.ObjectFactory;
import org.jboss.errai.bus.client.framework.MessageBus;
import org.jboss.errai.bus.server.ServerMessageBusImpl;
import org.jboss.errai.bus.server.api.ServerMessageBus;
import org.jboss.errai.bus.server.service.ErraiService;
import org.jboss.errai.bus.server.service.ErraiServiceConfigurator;
import org.jboss.errai.bus.server.service.ErraiServiceConfiguratorImpl;
import org.jboss.errai.bus.server.service.ErraiServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceObjectFactory
implements ObjectFactory {
    private static final Logger log = LoggerFactory.getLogger(ServiceObjectFactory.class);
    private static ErraiService serviceSingleton = null;

    public ServiceObjectFactory() {
        this.createService();
    }

    public void createService() {
        if (null == serviceSingleton) {
            serviceSingleton = (ErraiService)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

                public void configure() {
                    this.bind(MessageBus.class).to(ServerMessageBusImpl.class);
                    this.bind(ServerMessageBus.class).to(ServerMessageBusImpl.class);
                    this.bind(ErraiService.class).to(ErraiServiceImpl.class);
                    this.bind(ErraiServiceConfigurator.class).to(ErraiServiceConfiguratorImpl.class);
                }
            }}).getInstance(ErraiService.class);
            log.info("Creating service instance for development mode: " + serviceSingleton);
        }
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        return serviceSingleton;
    }
}

