/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.errai.cdi.server.gwt;

import com.google.gwt.core.ext.ServletContainer;
import com.google.gwt.core.ext.ServletContainerLauncher;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.shell.jetty.JettyNullLogger;
import com.google.gwt.dev.util.InstalledHelpInfo;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.jetty.AbstractConnector;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.RequestLog;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.RequestLogHandler;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.webapp.WebAppClassLoader;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.log.Log;
import org.mortbay.log.Logger;

public class MyJettyLauncher
extends ServletContainerLauncher {
    private static String[] __dftConfigurationClasses = new String[]{"org.mortbay.jetty.webapp.WebInfConfiguration", "org.mortbay.jetty.plus.webapp.EnvConfiguration", "org.mortbay.jetty.plus.webapp.Configuration", "org.mortbay.jetty.webapp.JettyWebXmlConfiguration"};
    private static final String PROPERTY_NOWARN_WEBAPP_CLASSPATH = "gwt.nowarn.webapp.classpath";

    public String getIconPath() {
        return null;
    }

    public String getName() {
        return "Jetty";
    }

    public ServletContainer start(TreeLogger logger, int port, File appRootDir) throws Exception {
        TreeLogger branch = logger.branch(TreeLogger.INFO, "Starting Jetty on port " + port, null);
        this.checkStartParams(branch, port, appRootDir);
        Log.setLog((Logger)new JettyTreeLogger(branch));
        System.setProperty("org.mortbay.xml.XmlParser.Validating", "false");
        AbstractConnector connector = this.getConnector();
        connector.setPort(port);
        connector.setReuseAddress(false);
        connector.setSoLingerTime(0);
        Server server = new Server();
        server.addConnector((Connector)connector);
        WebAppContextWithReload wac = new WebAppContextWithReload(logger, appRootDir.getAbsolutePath(), "/");
        wac.setConfigurationClasses(__dftConfigurationClasses);
        RequestLogHandler logHandler = new RequestLogHandler();
        logHandler.setRequestLog((RequestLog)new JettyRequestLogger(logger));
        logHandler.setHandler((Handler)wac);
        server.setHandler((Handler)logHandler);
        server.start();
        server.setStopAtShutdown(true);
        Log.setLog((Logger)new JettyTreeLogger(logger));
        return new JettyServletContainer(logger, server, wac, connector.getLocalPort(), appRootDir);
    }

    protected AbstractConnector getConnector() {
        return new SelectChannelConnector();
    }

    private void checkStartParams(TreeLogger logger, int port, File appRootDir) {
        if (logger == null) {
            throw new NullPointerException("logger cannot be null");
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port must be either 0 (for auto) or less than 65536");
        }
        if (appRootDir == null) {
            throw new NullPointerException("app root direcotry cannot be null");
        }
    }

    static {
        System.setProperty("org.mortbay.log.class", JettyNullLogger.class.getName());
        Log.getLog();
        String antJavaC = System.getProperty("build.compiler", "org.eclipse.jdt.core.JDTCompilerAdapter");
        System.setProperty("build.compiler", antJavaC);
    }

    protected static final class WebAppContextWithReload
    extends WebAppContext {
        private final ClassLoader bootStrapOnlyClassLoader = new ClassLoader(null){};
        private final TreeLogger logger;
        private final ClassLoader systemClassLoader = Thread.currentThread().getContextClassLoader();

        private WebAppContextWithReload(TreeLogger logger, String webApp, String contextPath) {
            super(webApp, contextPath);
            this.logger = logger;
            this.getInitParams().put("org.mortbay.jetty.servlet.Default.useFileMappedBuffer", "false");
            this.setParentLoaderPriority(true);
        }

        protected void doStart() throws Exception {
            this.setClassLoader((ClassLoader)((Object)new WebAppClassLoaderExtension()));
            super.doStart();
        }

        protected void doStop() throws Exception {
            super.doStop();
            this.setClassLoader(null);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class WebAppClassLoaderExtension
        extends WebAppClassLoader {
            private static final String META_INF_SERVICES = "META-INF/services/";

            public WebAppClassLoaderExtension() throws IOException {
                super(WebAppContextWithReload.this.bootStrapOnlyClassLoader, (WebAppContext)WebAppContextWithReload.this);
            }

            public URL findResource(String name) {
                URL found;
                String checkName = name;
                if (checkName.startsWith(META_INF_SERVICES)) {
                    checkName = checkName.substring(META_INF_SERVICES.length());
                }
                if (this.isSystemPath(checkName) && (found = WebAppContextWithReload.this.systemClassLoader.getResource(name)) != null) {
                    return found;
                }
                found = super.findResource(name);
                if (found != null) {
                    return found;
                }
                found = WebAppContextWithReload.this.systemClassLoader.getResource(name);
                if (found == null) {
                    return null;
                }
                String warnMessage = "Server resource '" + name + "' could not be found in the web app, but was found on the system classpath";
                if (!this.addContainingClassPathEntry(warnMessage, found, name)) {
                    return null;
                }
                return super.findResource(name);
            }

            public boolean isSystemPath(String name) {
                return super.isSystemPath(name = name.replace('/', '.')) || name.startsWith("org.apache.jasper.") || name.startsWith("org.apache.xerces.");
            }

            protected Class<?> findClass(String name) throws ClassNotFoundException {
                if (this.isSystemPath(name)) {
                    try {
                        return WebAppContextWithReload.this.systemClassLoader.loadClass(name);
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                }
                try {
                    return super.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    if (this.isServerPath(name)) {
                        throw e;
                    }
                    String resourceName = name.replace('.', '/') + ".class";
                    URL found = WebAppContextWithReload.this.systemClassLoader.getResource(resourceName);
                    if (found == null) {
                        return null;
                    }
                    String warnMessage = "Server class '" + name + "' could not be found in the web app, but was found on the system classpath";
                    if (!this.addContainingClassPathEntry(warnMessage, found, resourceName)) {
                        throw new ClassNotFoundException(name);
                    }
                    return super.findClass(name);
                }
            }

            private boolean addContainingClassPathEntry(String warnMessage, URL resource, String resourceName) {
                String classPathURL;
                TreeLogger.Type logLevel = System.getProperty(MyJettyLauncher.PROPERTY_NOWARN_WEBAPP_CLASSPATH) == null ? TreeLogger.WARN : TreeLogger.DEBUG;
                TreeLogger branch = WebAppContextWithReload.this.logger.branch(logLevel, warnMessage);
                String foundStr = resource.toExternalForm();
                if (resource.getProtocol().equals("file")) {
                    assert (foundStr.endsWith(resourceName));
                    classPathURL = foundStr.substring(0, foundStr.length() - resourceName.length());
                } else if (resource.getProtocol().equals("jar")) {
                    assert (foundStr.startsWith("jar:"));
                    assert (foundStr.endsWith("!/" + resourceName));
                    classPathURL = foundStr.substring(4, foundStr.length() - (2 + resourceName.length()));
                } else {
                    branch.log(TreeLogger.ERROR, "Found resouce but unrecognized URL format: '" + foundStr + '\'');
                    return false;
                }
                branch = branch.branch(logLevel, "Adding classpath entry '" + classPathURL + "' to the web app classpath for this session", null, (TreeLogger.HelpInfo)new InstalledHelpInfo("webAppClassPath.html"));
                try {
                    this.addClassPath(classPathURL);
                    return true;
                }
                catch (IOException e) {
                    branch.log(TreeLogger.ERROR, "Failed add container URL: '" + classPathURL + '\'', (Throwable)e);
                    return false;
                }
            }
        }
    }

    protected static class JettyServletContainer
    extends ServletContainer {
        private final int actualPort;
        private final File appRootDir;
        private final TreeLogger logger;
        private final Server server;
        private final WebAppContext wac;

        public JettyServletContainer(TreeLogger logger, Server server, WebAppContext wac, int actualPort, File appRootDir) {
            this.logger = logger;
            this.server = server;
            this.wac = wac;
            this.actualPort = actualPort;
            this.appRootDir = appRootDir;
        }

        public int getPort() {
            return this.actualPort;
        }

        public void refresh() throws UnableToCompleteException {
            String msg = "Reloading web app to reflect changes in " + this.appRootDir.getAbsolutePath();
            TreeLogger branch = this.logger.branch(TreeLogger.INFO, msg);
            Log.setLog((Logger)new JettyTreeLogger(branch));
            try {
                this.wac.stop();
                this.wac.start();
                branch.log(TreeLogger.INFO, "Reload completed successfully");
            }
            catch (Exception e) {
                branch.log(TreeLogger.ERROR, "Unable to restart embedded Jetty server", (Throwable)e);
                throw new UnableToCompleteException();
            }
            finally {
                Log.setLog((Logger)new JettyTreeLogger(this.logger));
            }
        }

        public void stop() throws UnableToCompleteException {
            TreeLogger branch = this.logger.branch(TreeLogger.INFO, "Stopping Jetty server");
            Log.setLog((Logger)new JettyTreeLogger(branch));
            try {
                this.server.stop();
                this.server.setStopAtShutdown(false);
                branch.log(TreeLogger.INFO, "Stopped successfully");
            }
            catch (Exception e) {
                branch.log(TreeLogger.ERROR, "Unable to stop embedded Jetty server", (Throwable)e);
                throw new UnableToCompleteException();
            }
            finally {
                Log.setLog((Logger)new JettyTreeLogger(this.logger));
            }
        }
    }

    public static class JettyTreeLogger
    implements Logger {
        private final TreeLogger logger;

        public JettyTreeLogger(TreeLogger logger) {
            if (logger == null) {
                throw new NullPointerException();
            }
            this.logger = logger;
        }

        public void debug(String msg, Object arg0, Object arg1) {
            this.logger.log(TreeLogger.SPAM, this.format(msg, arg0, arg1));
        }

        public void debug(String msg, Throwable th) {
            this.logger.log(TreeLogger.SPAM, msg, th);
        }

        public Logger getLogger(String name) {
            return this;
        }

        public void info(String msg, Object arg0, Object arg1) {
            this.logger.log(TreeLogger.INFO, this.format(msg, arg0, arg1));
        }

        public boolean isDebugEnabled() {
            return this.logger.isLoggable(TreeLogger.SPAM);
        }

        public void setDebugEnabled(boolean enabled) {
        }

        public void warn(String msg, Object arg0, Object arg1) {
            this.logger.log(TreeLogger.WARN, this.format(msg, arg0, arg1));
        }

        public void warn(String msg, Throwable th) {
            this.logger.log(TreeLogger.WARN, msg, th);
        }

        private String format(String msg, Object arg0, Object arg1) {
            int i1;
            int i0 = msg.indexOf("{}");
            int n = i1 = i0 < 0 ? -1 : msg.indexOf("{}", i0 + 2);
            if (arg1 != null && i1 >= 0) {
                msg = msg.substring(0, i1) + arg1 + msg.substring(i1 + 2);
            }
            if (arg0 != null && i0 >= 0) {
                msg = msg.substring(0, i0) + arg0 + msg.substring(i0 + 2);
            }
            return msg;
        }
    }

    public static class JettyRequestLogger
    extends AbstractLifeCycle
    implements RequestLog {
        private final TreeLogger logger;

        public JettyRequestLogger(TreeLogger logger) {
            this.logger = logger;
        }

        public void log(Request request, Response response) {
            TreeLogger branch;
            TreeLogger.Type logHeaders;
            TreeLogger.Type logStatus;
            int status = response.getStatus();
            if (status < 0) {
                status = 404;
            }
            if (status >= 500) {
                logStatus = TreeLogger.ERROR;
                logHeaders = TreeLogger.INFO;
            } else if (status >= 400) {
                logStatus = TreeLogger.WARN;
                logHeaders = TreeLogger.INFO;
            } else {
                logStatus = TreeLogger.INFO;
                logHeaders = TreeLogger.DEBUG;
            }
            String userString = request.getRemoteUser();
            userString = userString == null ? "" : userString + "@";
            String bytesString = "";
            if (response.getContentCount() > 0L) {
                bytesString = " " + response.getContentCount() + " bytes";
            }
            if (this.logger.isLoggable(logStatus) && (branch = this.logger.branch(logStatus, String.valueOf(status) + " - " + request.getMethod() + ' ' + request.getUri() + " (" + userString + request.getRemoteHost() + ')' + bytesString)).isLoggable(logHeaders)) {
                HttpFields.Field headerField;
                TreeLogger headers = branch.branch(logHeaders, "Request headers");
                Iterator headerFields = request.getConnection().getRequestFields().getFields();
                while (headerFields.hasNext()) {
                    headerField = (HttpFields.Field)headerFields.next();
                    headers.log(logHeaders, headerField.getName() + ": " + headerField.getValue());
                }
                headers = branch.branch(logHeaders, "Response headers");
                headerFields = response.getHttpFields().getFields();
                while (headerFields.hasNext()) {
                    headerField = (HttpFields.Field)headerFields.next();
                    headers.log(logHeaders, headerField.getName() + ": " + headerField.getValue());
                }
            }
        }
    }
}

