/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities.mapper.relation;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.persistence.NoResultException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.entities.PropertyData;
import org.hibernate.envers.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.entities.mapper.PropertyMapper;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.query.AuditEntity;
import org.hibernate.envers.reader.AuditReaderImplementor;
import org.hibernate.envers.tools.reflection.ReflectionTools;
import org.hibernate.property.Setter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneToOneNotOwningMapper
implements PropertyMapper {
    private String owningReferencePropertyName;
    private String owningEntityName;
    private PropertyData propertyData;

    public OneToOneNotOwningMapper(String owningReferencePropertyName, String owningEntityName, PropertyData propertyData) {
        this.owningReferencePropertyName = owningReferencePropertyName;
        this.owningEntityName = owningEntityName;
        this.propertyData = propertyData;
    }

    @Override
    public boolean mapToMapFromEntity(Map<String, Object> data, Object newObj, Object oldObj) {
        return false;
    }

    @Override
    public void mapToEntityFromMap(AuditConfiguration verCfg, Object obj, Map data, Object primaryKey, AuditReaderImplementor versionsReader, Number revision) {
        Object value;
        if (obj == null) {
            return;
        }
        Class<?> entityClass = ReflectionTools.loadClass(this.owningEntityName);
        try {
            value = versionsReader.createQuery().forEntitiesAtRevision(entityClass, revision).add(AuditEntity.relatedId(this.owningReferencePropertyName).eq(primaryKey)).getSingleResult();
        }
        catch (NoResultException e) {
            value = null;
        }
        catch (NonUniqueResultException e) {
            throw new AuditException("Many versions results for one-to-one relationship: (" + this.owningEntityName + ", " + this.owningReferencePropertyName + ")");
        }
        Setter setter = ReflectionTools.getSetter(obj.getClass(), this.propertyData);
        setter.set(obj, value, null);
    }

    @Override
    public List<PersistentCollectionChangeData> mapCollectionChanges(String referencingPropertyName, PersistentCollection newColl, Serializable oldColl, Serializable id) {
        return null;
    }
}

