/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities.mapper;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.entities.PropertyData;
import org.hibernate.envers.entities.mapper.CompositeMapperBuilder;
import org.hibernate.envers.entities.mapper.ExtendedPropertyMapper;
import org.hibernate.envers.entities.mapper.MultiPropertyMapper;
import org.hibernate.envers.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.entities.mapper.PropertyMapper;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.reader.AuditReaderImplementor;
import org.hibernate.envers.tools.reflection.ReflectionTools;
import org.hibernate.property.Getter;
import org.hibernate.property.Setter;
import org.hibernate.util.ReflectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentPropertyMapper
implements PropertyMapper,
CompositeMapperBuilder {
    private PropertyData propertyData;
    private ExtendedPropertyMapper delegate;

    public ComponentPropertyMapper(PropertyData propertyData) {
        this.propertyData = propertyData;
        this.delegate = new MultiPropertyMapper();
    }

    @Override
    public void add(PropertyData propertyData) {
        this.delegate.add(propertyData);
    }

    @Override
    public CompositeMapperBuilder addComponent(PropertyData propertyData) {
        return this.delegate.addComponent(propertyData);
    }

    @Override
    public void addComposite(PropertyData propertyData, PropertyMapper propertyMapper) {
        this.delegate.addComposite(propertyData, propertyMapper);
    }

    @Override
    public boolean mapToMapFromEntity(Map<String, Object> data, Object newObj, Object oldObj) {
        return this.delegate.mapToMapFromEntity(data, newObj, oldObj);
    }

    @Override
    public void mapToEntityFromMap(AuditConfiguration verCfg, Object obj, Map data, Object primaryKey, AuditReaderImplementor versionsReader, Number revision) {
        if (data == null || obj == null) {
            return;
        }
        Getter getter = ReflectionTools.getGetter(obj.getClass(), this.propertyData);
        Setter setter = ReflectionTools.getSetter(obj.getClass(), this.propertyData);
        try {
            Object subObj = ReflectHelper.getDefaultConstructor((Class)getter.getReturnType()).newInstance(new Object[0]);
            setter.set(obj, subObj, null);
            this.delegate.mapToEntityFromMap(verCfg, subObj, data, primaryKey, versionsReader, revision);
        }
        catch (Exception e) {
            throw new AuditException(e);
        }
    }

    @Override
    public List<PersistentCollectionChangeData> mapCollectionChanges(String referencingPropertyName, PersistentCollection newColl, Serializable oldColl, Serializable id) {
        return this.delegate.mapCollectionChanges(referencingPropertyName, newColl, oldColl, id);
    }
}

