/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.tools.reflection;

import java.util.Map;
import org.hibernate.property.BasicPropertyAccessor;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.Setter;
import org.hibernate.util.ReflectHelper;
import org.jboss.envers.exception.VersionsException;
import org.jboss.envers.tools.ConcurrentReferenceHashMap;
import org.jboss.envers.tools.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionTools {
    private static final Map<Pair<Class, String>, Getter> getterCache = new ConcurrentReferenceHashMap<Pair<Class, String>, Getter>(10, ConcurrentReferenceHashMap.ReferenceType.SOFT, ConcurrentReferenceHashMap.ReferenceType.STRONG);
    private static final Map<Pair<Class, String>, Setter> setterCache = new ConcurrentReferenceHashMap<Pair<Class, String>, Setter>(10, ConcurrentReferenceHashMap.ReferenceType.SOFT, ConcurrentReferenceHashMap.ReferenceType.STRONG);
    private static final PropertyAccessor BASIC_PROPERTY_ACCESSOR = new BasicPropertyAccessor();

    public static Class<?> loadClass(String name) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new VersionsException(e);
        }
    }

    public static Getter getGetter(Class cls, String propertyName) {
        Pair<Class, String> key = Pair.make(cls, propertyName);
        Getter value = getterCache.get(key);
        if (value == null) {
            value = ReflectHelper.getGetter((Class)cls, (String)propertyName);
            getterCache.put(key, value);
        }
        return value;
    }

    public static Setter getSetter(Class cls, String propertyName) {
        Pair<Class, String> key = Pair.make(cls, propertyName);
        Setter value = setterCache.get(key);
        if (value == null) {
            value = BASIC_PROPERTY_ACCESSOR.getSetter(cls, propertyName);
            setterCache.put(key, value);
        }
        return value;
    }
}

