/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.synchronization;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import javax.transaction.Synchronization;
import org.hibernate.FlushMode;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.hibernate.event.EventSource;
import org.jboss.envers.revisioninfo.RevisionInfoGenerator;
import org.jboss.envers.synchronization.VersionsSyncManager;
import org.jboss.envers.synchronization.work.VersionsWorkUnit;
import org.jboss.envers.tools.Pair;

public class VersionsSync
implements Synchronization {
    private final RevisionInfoGenerator revisionInfoGenerator;
    private final VersionsSyncManager manager;
    private final EventSource session;
    private final Transaction transaction;
    private final LinkedList<VersionsWorkUnit> workUnits;
    private final Queue<VersionsWorkUnit> undoQueue;
    private final Map<Pair<String, Object>, VersionsWorkUnit> usedIds;
    private Object revisionData;

    public VersionsSync(VersionsSyncManager manager, EventSource session, RevisionInfoGenerator revisionInfoGenerator) {
        this.manager = manager;
        this.session = session;
        this.revisionInfoGenerator = revisionInfoGenerator;
        this.transaction = session.getTransaction();
        this.workUnits = new LinkedList();
        this.undoQueue = new LinkedList<VersionsWorkUnit>();
        this.usedIds = new HashMap<Pair<String, Object>, VersionsWorkUnit>();
    }

    private void removeWorkUnit(VersionsWorkUnit vwu) {
        this.workUnits.remove(vwu);
        if (vwu.isPerformed()) {
            this.undoQueue.offer(vwu);
        }
    }

    public void addWorkUnit(VersionsWorkUnit vwu) {
        if (vwu.containsWork()) {
            Object entityId = vwu.getEntityId();
            if (entityId == null) {
                this.workUnits.offer(vwu);
            } else {
                String entityName = vwu.getEntityName();
                Pair<String, Object> usedIdsKey = Pair.make(entityName, entityId);
                if (this.usedIds.containsKey(usedIdsKey)) {
                    VersionsWorkUnit other = this.usedIds.get(usedIdsKey);
                    switch (vwu.dispatch(other)) {
                        case FIRST: {
                            break;
                        }
                        case SECOND: {
                            this.removeWorkUnit(other);
                            this.usedIds.put(usedIdsKey, vwu);
                            this.workUnits.offer(vwu);
                            break;
                        }
                        case NONE: {
                            this.removeWorkUnit(other);
                        }
                    }
                } else {
                    this.usedIds.put(usedIdsKey, vwu);
                    this.workUnits.offer(vwu);
                }
            }
        }
    }

    private void executeInSession(org.hibernate.Session session) {
        VersionsWorkUnit vwu;
        if (this.revisionData == null) {
            this.revisionData = this.revisionInfoGenerator.generate(session);
        }
        while ((vwu = this.undoQueue.poll()) != null) {
            vwu.undo(session);
        }
        while ((vwu = this.workUnits.poll()) != null) {
            vwu.perform(session, this.revisionData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeCompletion() {
        if (this.workUnits.size() == 0 && this.undoQueue.size() == 0) {
            return;
        }
        if (FlushMode.isManualFlushMode((FlushMode)this.session.getFlushMode())) {
            Session temporarySession = null;
            try {
                temporarySession = this.session.getFactory().openTemporarySession();
                this.executeInSession((org.hibernate.Session)temporarySession);
                temporarySession.flush();
            }
            finally {
                if (temporarySession != null) {
                    temporarySession.close();
                }
            }
        } else {
            this.executeInSession((org.hibernate.Session)this.session);
            this.session.flush();
        }
    }

    public void afterCompletion(int i) {
        this.manager.remove(this.transaction);
    }
}

