/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.revisioninfo;

import java.util.Date;
import org.hibernate.Query;
import org.hibernate.Session;

public class RevisionInfoQueryCreator {
    private final String revisionDateQuery;
    private final String revisionNumberForDateQuery;
    private final String revisionQuery;

    public RevisionInfoQueryCreator(String revisionInfoEntityName, String revisionInfoIdName, String revisionInfoTimestampName) {
        this.revisionDateQuery = "select rev." + revisionInfoTimestampName + " from " + revisionInfoEntityName + " rev where " + revisionInfoIdName + " = :_revision_number";
        this.revisionNumberForDateQuery = "select max(rev." + revisionInfoIdName + ") from " + revisionInfoEntityName + " rev where " + revisionInfoTimestampName + " <= :_revision_date";
        this.revisionQuery = "select rev from " + revisionInfoEntityName + " rev where " + revisionInfoIdName + " = :_revision_number";
    }

    public Query getRevisionDateQuery(Session session, Number revision) {
        return session.createQuery(this.revisionDateQuery).setParameter("_revision_number", (Object)revision);
    }

    public Query getRevisionNumberForDateQuery(Session session, Date date) {
        return session.createQuery(this.revisionNumberForDateQuery).setParameter("_revision_date", (Object)date.getTime());
    }

    public Query getRevisionQuery(Session session, Number revision) {
        return session.createQuery(this.revisionQuery).setParameter("_revision_number", (Object)revision);
    }
}

