/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.query.criteria;

import org.jboss.envers.configuration.VersionsConfiguration;
import org.jboss.envers.entities.RelationDescription;
import org.jboss.envers.entities.RelationType;
import org.jboss.envers.exception.VersionsException;

public class CriteriaTools {
    private CriteriaTools() {
    }

    public static void checkPropertyNotARelation(VersionsConfiguration verCfg, String entityName, String propertyName) throws VersionsException {
        if (verCfg.getEntCfg().get(entityName).isRelation(propertyName)) {
            throw new VersionsException("This criterion cannot be used on a property that is a relation to another property.");
        }
    }

    public static RelationDescription getRelatedEntity(VersionsConfiguration verCfg, String entityName, String propertyName) throws VersionsException {
        RelationDescription relationDesc = verCfg.getEntCfg().get(entityName).getRelationDescription(propertyName);
        if (relationDesc == null) {
            return null;
        }
        if (relationDesc.getRelationType() == RelationType.TO_ONE) {
            return relationDesc;
        }
        throw new VersionsException("This type of relation (" + entityName + "." + propertyName + ") isn't supported and can't be used in queries.");
    }
}

