/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.query.criteria;

import java.util.ArrayList;
import java.util.List;
import org.jboss.envers.configuration.VersionsConfiguration;
import org.jboss.envers.query.criteria.CriteriaTools;
import org.jboss.envers.query.criteria.ExtendableCriterion;
import org.jboss.envers.query.criteria.VersionsCriterion;
import org.jboss.envers.tools.query.Parameters;
import org.jboss.envers.tools.query.QueryBuilder;

public class AggregatedFieldVersionsExpression
implements VersionsCriterion,
ExtendableCriterion {
    private String propertyName;
    private AggregatedMode mode;
    private List<VersionsCriterion> criterions;

    public AggregatedFieldVersionsExpression(String propertyName, AggregatedMode mode) {
        this.propertyName = propertyName;
        this.mode = mode;
        this.criterions = new ArrayList<VersionsCriterion>();
    }

    public AggregatedFieldVersionsExpression add(VersionsCriterion criterion) {
        this.criterions.add(criterion);
        return this;
    }

    public void addToQuery(VersionsConfiguration verCfg, String entityName, QueryBuilder qb, Parameters parameters) {
        CriteriaTools.checkPropertyNotARelation(verCfg, entityName, this.propertyName);
        QueryBuilder subQb = qb.newSubQueryBuilder();
        for (VersionsCriterion versionsCriteria : this.criterions) {
            versionsCriteria.addToQuery(verCfg, entityName, qb, parameters);
            versionsCriteria.addToQuery(verCfg, entityName, subQb, subQb.getRootParameters());
        }
        switch (this.mode) {
            case MIN: {
                subQb.addProjection("min", this.propertyName, false);
                break;
            }
            case MAX: {
                subQb.addProjection("max", this.propertyName, false);
            }
        }
        parameters.addWhere(this.propertyName, "=", subQb);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AggregatedMode {
        MAX,
        MIN;

    }
}

