/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.entities.mapper.relation.lazy;

import java.util.Collection;
import java.util.List;
import org.jboss.envers.entities.mapper.relation.lazy.proxy.Initializor;
import org.jboss.envers.exception.VersionsException;
import org.jboss.envers.query.VersionsRestrictions;
import org.jboss.envers.reader.VersionsReaderImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneToManyAttachedInitializor<T extends Collection>
implements Initializor<T> {
    private VersionsReaderImplementor versionsReader;
    private Class<?> entityClass;
    private String owningReferencePropertyName;
    private Object primaryKey;
    private Number revision;
    private Class<T> collectionClass;

    public OneToManyAttachedInitializor(VersionsReaderImplementor versionsReader, Class<?> entityClass, String owningReferencePropertyName, Object primaryKey, Number revision, Class<T> collectionClass) {
        this.versionsReader = versionsReader;
        this.entityClass = entityClass;
        this.owningReferencePropertyName = owningReferencePropertyName;
        this.primaryKey = primaryKey;
        this.revision = revision;
        this.collectionClass = collectionClass;
    }

    @Override
    public T initialize() {
        Collection result;
        List queryResult = this.versionsReader.createQuery().forEntitiesAtRevision(this.entityClass, this.revision).add(VersionsRestrictions.relatedIdEq(this.owningReferencePropertyName, this.primaryKey)).getResultList();
        if (this.collectionClass.isAssignableFrom(queryResult.getClass())) {
            return (T)queryResult;
        }
        try {
            result = (Collection)this.collectionClass.newInstance();
        }
        catch (Exception e) {
            throw new VersionsException(e);
        }
        result.addAll(queryResult);
        return (T)result;
    }
}

