/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.entities.mapper.relation.lazy;

import java.util.Collection;
import java.util.List;
import org.jboss.envers.configuration.VersionsConfiguration;
import org.jboss.envers.entities.EntityInstantiator;
import org.jboss.envers.entities.mapper.relation.DetachedRelationQueryGenerator;
import org.jboss.envers.entities.mapper.relation.lazy.proxy.Initializor;
import org.jboss.envers.exception.VersionsException;
import org.jboss.envers.reader.VersionsReaderImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetachedRelationInitializor<T extends Collection>
implements Initializor<T> {
    private final VersionsConfiguration verCfg;
    private final String entityName;
    private final DetachedRelationQueryGenerator queryGenerator;
    private final VersionsReaderImplementor versionsReader;
    private final Object primaryKey;
    private final Number revision;
    private final Class<T> collectionClass;

    public DetachedRelationInitializor(VersionsConfiguration verCfg, String entityName, DetachedRelationQueryGenerator queryGenerator, VersionsReaderImplementor versionsReader, Object primaryKey, Number revision, Class<T> collectionClass) {
        this.verCfg = verCfg;
        this.entityName = entityName;
        this.queryGenerator = queryGenerator;
        this.versionsReader = versionsReader;
        this.primaryKey = primaryKey;
        this.revision = revision;
        this.collectionClass = collectionClass;
    }

    @Override
    public T initialize() {
        Collection result;
        EntityInstantiator entityInstantiator = new EntityInstantiator(this.verCfg, this.versionsReader);
        List queryResult = this.queryGenerator.getQuery(this.versionsReader, this.primaryKey, this.revision).list();
        try {
            result = (Collection)this.collectionClass.newInstance();
        }
        catch (Exception e) {
            throw new VersionsException(e);
        }
        entityInstantiator.addInstancesFromVersionsEntities(this.entityName, result, queryResult, this.revision);
        return (T)result;
    }
}

