/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.configuration;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.DOMWriter;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.hibernate.MappingException;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.PersistentClass;
import org.jboss.envers.configuration.GlobalConfiguration;
import org.jboss.envers.configuration.PersistentClassGraphDefiner;
import org.jboss.envers.configuration.VersionsEntitiesConfiguration;
import org.jboss.envers.configuration.metadata.AnnotationsMetadataReader;
import org.jboss.envers.configuration.metadata.EntityMappingData;
import org.jboss.envers.configuration.metadata.PersistentClassVersioningData;
import org.jboss.envers.configuration.metadata.VersionsMetadataGenerator;
import org.jboss.envers.entities.EntitiesConfigurations;
import org.jboss.envers.tools.graph.GraphTopologicalSort;
import org.jboss.envers.tools.reflection.YReflectionManager;

public class EntitiesConfigurator {
    public EntitiesConfigurations configure(Configuration cfg, YReflectionManager reflectionManager, GlobalConfiguration globalCfg, VersionsEntitiesConfiguration verEntCfg, Document revisionInfoXmlMapping, Element revisionInfoRelationMapping) {
        EntityMappingData mappingData;
        VersionsMetadataGenerator versionsMetaGen = new VersionsMetadataGenerator(cfg, globalCfg, verEntCfg, revisionInfoRelationMapping);
        DOMWriter writer = new DOMWriter();
        Iterator<PersistentClass> classes = GraphTopologicalSort.sort(new PersistentClassGraphDefiner(cfg)).iterator();
        HashMap<PersistentClass, PersistentClassVersioningData> pcDatas = new HashMap<PersistentClass, PersistentClassVersioningData>();
        HashMap<PersistentClass, EntityMappingData> xmlMappings = new HashMap<PersistentClass, EntityMappingData>();
        AnnotationsMetadataReader annotationsMetadataReader = new AnnotationsMetadataReader();
        while (classes.hasNext()) {
            PersistentClass pc = classes.next();
            PersistentClassVersioningData versioningData = annotationsMetadataReader.getVersioningData(pc, reflectionManager, globalCfg);
            if (!versioningData.isVersioned()) continue;
            pcDatas.put(pc, versioningData);
            if (versioningData.versionsTableName != null) {
                verEntCfg.addCustomVersionsTableName(pc.getEntityName(), versioningData.versionsTableName);
            }
            mappingData = new EntityMappingData();
            versionsMetaGen.generateFirstPass(pc, versioningData, mappingData);
            xmlMappings.put(pc, mappingData);
        }
        for (PersistentClass pc : pcDatas.keySet()) {
            mappingData = (EntityMappingData)xmlMappings.get(pc);
            versionsMetaGen.generateSecondPass(pc, (PersistentClassVersioningData)pcDatas.get(pc), mappingData);
            try {
                cfg.addDocument(writer.write(mappingData.getMainMapping()));
                for (Document additionalMapping : mappingData.getAdditionalMappings()) {
                    cfg.addDocument(writer.write(additionalMapping));
                }
            }
            catch (DocumentException e) {
                throw new MappingException((Throwable)e);
            }
        }
        if (pcDatas.size() > 0) {
            try {
                if (revisionInfoXmlMapping != null) {
                    cfg.addDocument(writer.write(revisionInfoXmlMapping));
                }
            }
            catch (DocumentException e) {
                throw new MappingException((Throwable)e);
            }
        }
        return new EntitiesConfigurations(versionsMetaGen.getEntitiesConfigurations());
    }

    private void writeDocument(Document e) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter w = new PrintWriter(baos);
        try {
            XMLWriter xw = new XMLWriter((Writer)w, new OutputFormat(" ", true));
            xw.write(e);
            ((Writer)w).flush();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        System.out.println("-----------");
        System.out.println(baos.toString());
        System.out.println("-----------");
    }
}

