/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode.stackmap;

import javassist.bytecode.BadBytecode;
import javassist.bytecode.ByteArray;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.Opcode;

public class StackAnalyzerCore {
    private ConstPool cpool;
    private int stackTop;
    private int[] stackTypes;
    private Object[] stackData;
    private int[] localsTypes;
    private boolean[] localsUpdated;
    private Object[] localsData;
    static final int EMPTY = -1;
    static final int TOP = 0;
    static final int INTEGER = 1;
    static final int FLOAT = 2;
    static final int DOUBLE = 3;
    static final int LONG = 4;
    static final int NULL = 5;
    static final int THIS = 6;
    static final int OBJECT = 7;
    static final int UNINIT = 8;

    public StackAnalyzerCore(ConstPool cp, int maxStack, int maxLocals) {
        this.cpool = cp;
        this.stackTop = 0;
        this.stackTypes = null;
        this.localsTypes = null;
        this.growStack(maxStack);
        this.growLocals(maxLocals);
    }

    public void clearUpdatedFlags() {
        boolean[] updated = this.localsUpdated;
        for (int i = 0; i < updated.length; ++i) {
            updated[i] = false;
        }
    }

    public void growStack(int size) {
        int oldSize;
        int[] types = new int[size];
        Object[] data = new Object[size];
        if (this.stackTypes == null) {
            oldSize = 0;
        } else {
            oldSize = this.stackTypes.length;
            System.arraycopy(this.stackTypes, 0, types, 0, oldSize);
            System.arraycopy(this.stackData, 0, data, 0, oldSize);
        }
        this.stackTypes = types;
        this.stackData = data;
        for (int i = oldSize; i < size; ++i) {
            this.stackTypes[i] = -1;
        }
    }

    public void growLocals(int size) {
        int oldSize;
        int[] types = new int[size];
        boolean[] updated = new boolean[size];
        Object[] data = new Object[size];
        if (this.localsTypes == null) {
            oldSize = 0;
        } else {
            oldSize = this.localsTypes.length;
            System.arraycopy(this.localsTypes, 0, types, 0, oldSize);
            System.arraycopy(this.localsUpdated, 0, updated, 0, oldSize);
            System.arraycopy(this.localsData, 0, data, 0, oldSize);
        }
        this.localsTypes = types;
        this.localsUpdated = updated;
        this.localsData = data;
        for (int i = oldSize; i < size; ++i) {
            this.localsTypes[i] = -1;
        }
    }

    public void pushType(int type, Object data) {
        this.stackTypes[this.stackTop] = type;
        this.stackData[this.stackTop++] = data;
    }

    protected int doOpcode(int pos, byte[] code) throws BadBytecode {
        int op = code[pos] & 0xFF;
        if (op < 96) {
            if (op < 54) {
                return this.doOpcode0_53(pos, code, op);
            }
            return this.doOpcode54_95(pos, code, op);
        }
        if (op < 148) {
            return this.doOpcode96_147(pos, code, op);
        }
        return this.doOpcode148_201(pos, code, op);
    }

    protected void visitBranch(int pos, byte[] code, int offset) {
    }

    protected void visitGoto(int pos, byte[] code, int offset) {
    }

    protected void visitTableSwitch(int pos, byte[] code, int n, int offsetPos, int defaultByte) {
    }

    protected void visitLookupSwitch(int pos, byte[] code, int n, int pairsPos, int defaultByte) {
    }

    protected void visitReturn(int pos, byte[] code) {
    }

    protected void visitThrow(int pos, byte[] code) {
    }

    protected void visitJSR(int pos, byte[] code) throws BadBytecode {
        this.throwBadBytecode(pos, "jsr");
    }

    protected void visitRET(int pos, byte[] code) throws BadBytecode {
        this.throwBadBytecode(pos, "ret");
    }

    private void throwBadBytecode(int pos, String name) throws BadBytecode {
        throw new BadBytecode(name + " at " + pos);
    }

    private int doOpcode0_53(int pos, byte[] code, int op) throws BadBytecode {
        int[] stackTypes = this.stackTypes;
        switch (op) {
            case 0: {
                break;
            }
            case 1: {
                stackTypes[this.stackTop++] = 5;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                stackTypes[this.stackTop++] = 1;
                break;
            }
            case 9: 
            case 10: {
                stackTypes[this.stackTop++] = 4;
                stackTypes[this.stackTop++] = 0;
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                stackTypes[this.stackTop++] = 2;
                break;
            }
            case 14: 
            case 15: {
                stackTypes[this.stackTop++] = 3;
                stackTypes[this.stackTop++] = 0;
                break;
            }
            case 16: 
            case 17: {
                stackTypes[this.stackTop++] = 1;
                return op == 17 ? 3 : 2;
            }
            case 18: {
                this.doLDC(code[pos + 1] & 0xFF);
                return 2;
            }
            case 19: 
            case 20: {
                this.doLDC(ByteArray.readU16bit(code, pos + 1));
                return 3;
            }
            case 21: {
                return this.doXLOAD(1);
            }
            case 22: {
                return this.doXLOAD(4);
            }
            case 23: {
                return this.doXLOAD(2);
            }
            case 24: {
                return this.doXLOAD(3);
            }
            case 25: {
                stackTypes[this.stackTop] = 7;
                this.stackData[this.stackTop++] = this.localsData[code[pos + 1] & 0xFF];
                return 2;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                stackTypes[this.stackTop++] = 1;
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                stackTypes[this.stackTop++] = 4;
                stackTypes[this.stackTop++] = 0;
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                stackTypes[this.stackTop++] = 2;
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                stackTypes[this.stackTop++] = 3;
                stackTypes[this.stackTop++] = 0;
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                stackTypes[this.stackTop] = 7;
                this.stackData[this.stackTop++] = this.localsData[op - 42];
                break;
            }
            case 46: {
                stackTypes[--this.stackTop - 1] = 1;
                break;
            }
            case 47: {
                stackTypes[this.stackTop - 2] = 4;
                stackTypes[this.stackTop - 1] = 0;
                break;
            }
            case 48: {
                stackTypes[--this.stackTop - 1] = 2;
                break;
            }
            case 49: {
                stackTypes[this.stackTop - 2] = 3;
                stackTypes[this.stackTop - 1] = 0;
                break;
            }
            case 50: {
                int s = --this.stackTop - 1;
                stackTypes[s] = 7;
                Object data = this.stackData[s];
                if (data != null && data instanceof String) {
                    this.stackData[s] = this.getDerefType((String)data);
                    break;
                }
                throw new BadBytecode("bad AALOAD");
            }
            case 51: 
            case 52: 
            case 53: {
                stackTypes[--this.stackTop - 1] = 1;
                break;
            }
            default: {
                throw new RuntimeException("fatal");
            }
        }
        return 1;
    }

    private void doLDC(int index) {
        int[] stackTypes = this.stackTypes;
        int tag = this.cpool.getTag(index);
        if (tag == 8) {
            stackTypes[this.stackTop] = 7;
            this.stackData[this.stackTop++] = "java/lang/String";
        } else if (tag == 3) {
            stackTypes[this.stackTop++] = 1;
        } else if (tag == 4) {
            stackTypes[this.stackTop++] = 2;
        } else if (tag == 5) {
            stackTypes[this.stackTop++] = 4;
            stackTypes[this.stackTop++] = 0;
        } else if (tag == 6) {
            stackTypes[this.stackTop++] = 3;
            stackTypes[this.stackTop++] = 0;
        } else if (tag == 7) {
            stackTypes[this.stackTop] = 7;
            this.stackData[this.stackTop++] = "java/lang/Class";
        } else {
            throw new RuntimeException("bad LDC: " + tag);
        }
    }

    private int doXLOAD(int type) {
        int[] stackTypes = this.stackTypes;
        stackTypes[this.stackTop++] = type;
        if (type == 4 || type == 3) {
            stackTypes[this.stackTop++] = 0;
        }
        return 2;
    }

    private String getDerefType(String type) throws BadBytecode {
        String type2;
        if (type.charAt(0) == '[' && (type2 = type.substring(1)).length() > 0) {
            char c = type2.charAt(0);
            if (c == '[') {
                return type2;
            }
            if (c == 'L') {
                return type2.substring(1, type.length() - 2);
            }
            return type2;
        }
        throw new BadBytecode("bad array type for AALOAD: " + type);
    }

    private int doOpcode54_95(int pos, byte[] code, int op) {
        int[] localsTypes = this.localsTypes;
        int[] stackTypes = this.stackTypes;
        switch (op) {
            case 54: {
                return this.doXSTORE(pos, code, 1);
            }
            case 55: {
                return this.doXSTORE(pos, code, 4);
            }
            case 56: {
                return this.doXSTORE(pos, code, 2);
            }
            case 57: {
                return this.doXSTORE(pos, code, 3);
            }
            case 58: {
                return this.doXSTORE(pos, code, 7);
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                int var = op - 59;
                localsTypes[var] = 1;
                this.localsUpdated[var] = true;
                --this.stackTop;
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                int var = op - 63;
                localsTypes[var] = 4;
                localsTypes[var + 1] = 0;
                this.localsUpdated[var] = true;
                this.stackTop -= 2;
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                int var = op - 67;
                localsTypes[var] = 2;
                this.localsUpdated[var] = true;
                --this.stackTop;
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                int var = op - 71;
                localsTypes[var] = 3;
                localsTypes[var + 1] = 0;
                this.localsUpdated[var] = true;
                this.stackTop -= 2;
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                int var = op - 75;
                localsTypes[var] = 7;
                this.localsUpdated[var] = true;
                this.localsData[var] = this.stackData[--this.stackTop];
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                this.stackTop -= op == 80 || op == 82 ? 4 : 3;
                break;
            }
            case 87: {
                --this.stackTop;
                break;
            }
            case 88: {
                this.stackTop -= 2;
                break;
            }
            case 89: {
                int sp = this.stackTop;
                stackTypes[sp] = stackTypes[sp - 1];
                this.stackData[sp] = this.stackData[sp - 1];
                this.stackTop = sp + 1;
                break;
            }
            case 90: 
            case 91: {
                int len = op - 90 + 2;
                this.doDUP_XX(1, len);
                int sp = this.stackTop;
                stackTypes[sp - len] = stackTypes[sp];
                this.stackData[sp - len] = this.stackData[sp];
                this.stackTop = sp + 1;
                break;
            }
            case 92: {
                this.doDUP_XX(2, 2);
                this.stackTop += 2;
                break;
            }
            case 93: 
            case 94: {
                int len = op - 93 + 3;
                this.doDUP_XX(2, len);
                Object[] stackData = this.stackData;
                int sp = this.stackTop;
                stackTypes[sp - len] = stackTypes[sp];
                stackData[sp - len] = stackData[sp];
                stackTypes[sp - len + 1] = stackTypes[sp + 1];
                stackData[sp - len + 1] = stackData[sp + 1];
                this.stackTop = sp + 2;
                break;
            }
            case 95: {
                Object[] stackData = this.stackData;
                int sp = this.stackTop - 1;
                int t = stackTypes[sp];
                Object d = stackData[sp];
                stackTypes[sp] = stackTypes[sp - 1];
                stackData[sp] = stackData[sp - 1];
                stackTypes[sp - 1] = t;
                stackData[sp - 1] = d;
                break;
            }
            default: {
                throw new RuntimeException("fatal");
            }
        }
        return 1;
    }

    private int doXSTORE(int pos, byte[] code, int type) {
        int index = code[pos + 1] & 0xFF;
        return this.doXSTORE(index, type);
    }

    private int doXSTORE(int index, int type) {
        --this.stackTop;
        this.localsTypes[index] = type;
        this.localsUpdated[index] = true;
        if (type == 4 || type == 3) {
            --this.stackTop;
            this.localsTypes[index + 1] = 0;
        } else if (type == 7) {
            this.localsData[index] = this.stackData[this.stackTop];
        }
        return 2;
    }

    private void doDUP_XX(int delta, int len) {
        int sp;
        int[] types = this.stackTypes;
        Object[] data = this.stackData;
        int end = sp - len;
        for (sp = this.stackTop; sp > end; --sp) {
            types[sp + delta] = types[sp];
            data[sp + delta] = data[sp];
        }
    }

    private int doOpcode96_147(int pos, byte[] code, int op) {
        if (op <= 131) {
            this.stackTop -= Opcode.STACK_GROW[op];
            return 1;
        }
        switch (op) {
            case 132: {
                return 3;
            }
            case 133: {
                this.stackTypes[this.stackTop] = 4;
                this.stackTypes[this.stackTop - 1] = 0;
                ++this.stackTop;
                break;
            }
            case 134: {
                this.stackTypes[this.stackTop - 1] = 2;
                break;
            }
            case 135: {
                this.stackTypes[this.stackTop] = 3;
                this.stackTypes[this.stackTop - 1] = 0;
                ++this.stackTop;
                break;
            }
            case 136: {
                this.stackTypes[--this.stackTop - 1] = 1;
                break;
            }
            case 137: {
                this.stackTypes[--this.stackTop - 1] = 2;
                break;
            }
            case 138: {
                this.stackTypes[this.stackTop - 1] = 3;
                break;
            }
            case 139: {
                this.stackTypes[this.stackTop - 1] = 1;
                break;
            }
            case 140: {
                this.stackTypes[this.stackTop - 1] = 0;
                this.stackTypes[this.stackTop++] = 4;
                break;
            }
            case 141: {
                this.stackTypes[this.stackTop - 1] = 0;
                this.stackTypes[this.stackTop++] = 3;
                break;
            }
            case 142: {
                this.stackTypes[--this.stackTop - 1] = 1;
                break;
            }
            case 143: {
                this.stackTypes[this.stackTop - 1] = 4;
                break;
            }
            case 144: {
                this.stackTypes[--this.stackTop - 1] = 2;
                break;
            }
            case 145: 
            case 146: 
            case 147: {
                break;
            }
            default: {
                throw new RuntimeException("fatal");
            }
        }
        return 1;
    }

    private int doOpcode148_201(int pos, byte[] code, int op) throws BadBytecode {
        switch (op) {
            case 148: {
                this.stackTypes[this.stackTop - 4] = 1;
                this.stackTop -= 3;
                break;
            }
            case 149: 
            case 150: {
                this.stackTypes[--this.stackTop - 1] = 1;
                break;
            }
            case 151: 
            case 152: {
                this.stackTypes[this.stackTop - 4] = 1;
                this.stackTop -= 3;
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                --this.stackTop;
                this.visitBranch(pos, code, ByteArray.readS16bit(code, pos + 1));
                return 3;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                this.stackTop -= 2;
                this.visitBranch(pos, code, ByteArray.readS16bit(code, pos + 1));
                return 3;
            }
            case 167: {
                this.visitGoto(pos, code, ByteArray.readS16bit(code, pos + 1));
                return 3;
            }
            case 168: {
                this.stackTypes[this.stackTop++] = 0;
                this.visitJSR(pos, code);
                return 3;
            }
            case 169: {
                this.visitRET(pos, code);
                return 2;
            }
            case 170: {
                --this.stackTop;
                int pos2 = (pos & 0xFFFFFFFC) + 8;
                int low = ByteArray.read32bit(code, pos2);
                int high = ByteArray.read32bit(code, pos2 + 4);
                int n = high - low + 1;
                this.visitTableSwitch(pos, code, n, pos2 + 8, ByteArray.read32bit(code, pos2 - 4));
                return n * 4 + 16 - (pos & 3);
            }
            case 171: {
                --this.stackTop;
                int pos2 = (pos & 0xFFFFFFFC) + 8;
                int n = ByteArray.read32bit(code, pos2);
                this.visitLookupSwitch(pos, code, n, pos2 + 4, ByteArray.read32bit(code, pos2 - 4));
                return n * 8 + 12 - (pos & 3);
            }
            case 172: {
                --this.stackTop;
                this.visitReturn(pos, code);
                break;
            }
            case 173: {
                this.stackTop -= 2;
                this.visitReturn(pos, code);
                break;
            }
            case 174: {
                --this.stackTop;
                this.visitReturn(pos, code);
                break;
            }
            case 175: {
                this.stackTop -= 2;
                this.visitReturn(pos, code);
                break;
            }
            case 176: {
                --this.stackTop;
                this.visitReturn(pos, code);
                break;
            }
            case 177: {
                this.visitReturn(pos, code);
                break;
            }
            case 178: {
                return this.doFieldAccess(pos, code, true);
            }
            case 179: {
                return this.doFieldAccess(pos, code, false);
            }
            case 180: {
                --this.stackTop;
                return this.doFieldAccess(pos, code, true);
            }
            case 181: {
                --this.stackTop;
                return this.doFieldAccess(pos, code, false);
            }
            case 182: 
            case 183: {
                return this.doInvokeMethod(pos, code, 1);
            }
            case 184: {
                return this.doInvokeMethod(pos, code, 0);
            }
            case 185: {
                return this.doInvokeIntfMethod(pos, code, 1);
            }
            case 186: {
                throw new RuntimeException("bad opcode 186");
            }
            case 187: {
                int i = ByteArray.readU16bit(code, pos + 1);
                this.stackTypes[this.stackTop - 1] = 8;
                this.stackData[this.stackTop - 1] = new Integer(pos);
                return 3;
            }
            case 188: {
                return this.doNEWARRAY(pos, code);
            }
            case 189: {
                int i = ByteArray.readU16bit(code, pos + 1);
                this.stackTypes[this.stackTop - 1] = 7;
                this.stackData[this.stackTop - 1] = "[L" + this.cpool.getClassInfo(i).replace('.', '/') + ";";
                return 3;
            }
            case 190: {
                this.stackTypes[this.stackTop - 1] = 1;
                break;
            }
            case 191: {
                --this.stackTop;
                this.visitThrow(pos, code);
                break;
            }
            case 192: {
                int i = ByteArray.readU16bit(code, pos + 1);
                this.stackData[this.stackTop - 1] = this.cpool.getClassInfo(i);
                return 3;
            }
            case 193: {
                this.stackTypes[this.stackTop - 1] = 1;
                return 3;
            }
            case 194: 
            case 195: {
                --this.stackTop;
                break;
            }
            case 196: {
                return this.doWIDE(pos, code);
            }
            case 197: {
                return this.doMultiANewArray(pos, code);
            }
            case 198: 
            case 199: {
                --this.stackTop;
                this.visitBranch(pos, code, ByteArray.readS16bit(code, pos + 1));
                return 3;
            }
            case 200: {
                this.visitGoto(pos, code, ByteArray.read32bit(code, pos + 1));
                return 5;
            }
            case 201: {
                this.stackTypes[this.stackTop++] = 0;
                this.visitJSR(pos, code);
                return 5;
            }
        }
        return 1;
    }

    private int doWIDE(int pos, byte[] code) {
        int op = code[pos + 1] & 0xFF;
        switch (op) {
            case 21: {
                this.doXLOAD(1);
                break;
            }
            case 22: {
                this.doXLOAD(4);
                break;
            }
            case 23: {
                this.doXLOAD(2);
                break;
            }
            case 24: {
                this.doXLOAD(3);
                break;
            }
            case 25: {
                this.stackTypes[this.stackTop] = 7;
                this.stackData[this.stackTop++] = this.localsData[ByteArray.readU16bit(code, pos)];
                break;
            }
            case 54: {
                return this.doWIDE_STORE(pos, code, 1);
            }
            case 55: {
                return this.doWIDE_STORE(pos, code, 4);
            }
            case 56: {
                return this.doWIDE_STORE(pos, code, 2);
            }
            case 57: {
                return this.doWIDE_STORE(pos, code, 3);
            }
            case 58: {
                return this.doWIDE_STORE(pos, code, 7);
            }
            case 132: {
                return 6;
            }
            case 169: {
                break;
            }
            default: {
                throw new RuntimeException("bad WIDE instruction: " + op);
            }
        }
        return 4;
    }

    private int doWIDE_STORE(int pos, byte[] code, int type) {
        int index = ByteArray.readU16bit(code, pos);
        return this.doXSTORE(index, type);
    }

    private int doFieldAccess(int pos, byte[] code, boolean isGet) {
        int index = ByteArray.readU16bit(code, pos + 1);
        String desc = this.cpool.getFieldrefType(index);
        if (isGet) {
            this.pushMemberType(desc);
        } else {
            this.stackTop -= Descriptor.dataSize(desc);
        }
        return 3;
    }

    /*
     * WARNING - void declaration
     */
    private int doNEWARRAY(int pos, byte[] code) {
        void var4_4;
        int s = this.stackTop - 1;
        this.stackTypes[s] = 7;
        switch (code[pos + 1] & 0xFF) {
            case 4: {
                String type = "[Z";
                break;
            }
            case 5: {
                String type = "[C";
                break;
            }
            case 6: {
                String type = "[F";
                break;
            }
            case 7: {
                String type = "[D";
                break;
            }
            case 8: {
                String type = "[B";
                break;
            }
            case 9: {
                String type = "[S";
                break;
            }
            case 10: {
                String type = "[I";
                break;
            }
            case 11: {
                String type = "[J";
                break;
            }
            default: {
                throw new RuntimeException("bad newarray");
            }
        }
        this.stackData[s] = var4_4;
        return 2;
    }

    private int doMultiANewArray(int pos, byte[] code) {
        int i = ByteArray.readU16bit(code, pos + 1);
        int dim = code[pos + 3] & 0xFF;
        this.stackTop -= dim - 1;
        String type = this.cpool.getClassInfo(i);
        StringBuffer sbuf = new StringBuffer();
        while (dim-- > 0) {
            sbuf.append('[');
        }
        sbuf.append('L').append(type.replace('.', '/')).append(';');
        this.stackTypes[this.stackTop - 1] = 7;
        this.stackData[this.stackTop - 1] = sbuf.toString();
        return 4;
    }

    private int doInvokeMethod(int pos, byte[] code, int targetSize) {
        int i = ByteArray.readU16bit(code, pos + 1);
        String desc = this.cpool.getMethodrefType(i);
        this.stackTop -= Descriptor.paramSize(desc) + targetSize;
        this.pushMemberType(desc);
        return 3;
    }

    private int doInvokeIntfMethod(int pos, byte[] code, int targetSize) {
        int i = ByteArray.readU16bit(code, pos + 1);
        String desc = this.cpool.getInterfaceMethodrefType(i);
        this.stackTop -= Descriptor.paramSize(desc) + targetSize;
        this.pushMemberType(desc);
        return 5;
    }

    private void pushMemberType(String descriptor) {
        int top = 0;
        if (descriptor.charAt(0) == '(' && (top = descriptor.indexOf(41) + 1) < 1) {
            throw new IndexOutOfBoundsException("bad descriptor: " + descriptor);
        }
        int[] types = this.stackTypes;
        int index = this.stackTop;
        switch (descriptor.charAt(top)) {
            case '[': {
                types[index] = 7;
                this.stackData[index] = descriptor.substring(top);
                break;
            }
            case 'L': {
                types[index] = 7;
                this.stackData[index] = descriptor.substring(top + 1, descriptor.indexOf(59, top));
                break;
            }
            case 'J': {
                types[index] = 4;
                types[index + 1] = 0;
                this.stackTop += 2;
                return;
            }
            case 'F': {
                types[index] = 2;
                break;
            }
            case 'D': {
                types[index] = 3;
                types[index + 1] = 0;
                this.stackTop += 2;
                return;
            }
            case 'V': {
                return;
            }
            default: {
                types[index] = 1;
            }
        }
        ++this.stackTop;
    }
}

