/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.embedded.api.server;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.logging.Logger;

public class JBossHomeClassLoader
extends URLClassLoader {
    private static final Logger log = Logger.getLogger(JBossHomeClassLoader.class.getName());
    private static final String DIR_NAME_LIB = "lib/";
    private static final String[] JBOSS_LIB_BOOT_LIST = new String[]{"concurrent.jar", "log4j-boot.jar", "jboss-logging-spi.jar", "jboss-logging-log4j.jar", "jboss-logging-jdk.jar", "jboss-logmanager.jar", "jboss-logbridge.jar", "jboss-common-core.jar", "jboss-xml-binding.jar", "jboss-bootstrap-spi.jar", "jboss-bootstrap-spi-as.jar", "jboss-bootstrap-spi-mc.jar", "jboss-bootstrap-impl-base.jar", "jboss-bootstrap-impl-as.jar", "jboss-bootstrap-impl-mc.jar", "jboss-bootstrap-api-as.jar", "jboss-bootstrap-api-mc.jar", "jboss-bootstrap-api.jar", "javassist.jar", "jboss-reflect.jar", "jboss-mdr.jar", "jboss-dependency.jar", "jboss-kernel.jar", "jboss-metatype.jar", "jboss-managed.jar", "jboss-deployers-core-spi.jar", "jboss-deployers-client-spi.jar", "jboss-vfs.jar", "jboss-classloading-spi.jar", "jboss-classloader.jar", "jboss-classloading.jar", "jboss-classloading-vfs.jar", "jboss-aop.jar", "jboss-aop-mc-int.jar", "trove.jar"};

    private JBossHomeClassLoader(URL[] urls, ClassLoader parent) throws IllegalArgumentException, IllegalStateException {
        super(urls, parent);
    }

    public static JBossHomeClassLoader newInstance(URL jbossHome, URL[] urls, ClassLoader parent) {
        if (jbossHome == null) {
            throw new IllegalArgumentException("JBOSS_HOME must be specified");
        }
        URL[] jbossLibBootUrls = JBossHomeClassLoader.getJBossLibBootUrls(jbossHome);
        URL[] merged = JBossHomeClassLoader.merge(jbossLibBootUrls, urls);
        return new JBossHomeClassLoader(merged, parent);
    }

    private static URL[] merge(URL[] ... urls) throws IllegalArgumentException {
        assert (urls != null) : "URLs must be specified";
        HashSet<URL> urlSet = new HashSet<URL>();
        URL[][] arr$ = urls;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            URL[] current;
            for (URL single : current = arr$[i$]) {
                urlSet.add(single);
            }
        }
        return urlSet.toArray(new URL[0]);
    }

    private static URL[] getJBossLibBootUrls(URL jbossHome) {
        URL jbossLib;
        try {
            jbossLib = new URL(jbossHome, DIR_NAME_LIB);
        }
        catch (MalformedURLException murle) {
            throw new RuntimeException("Error in constructing $JBOSS_HOME/lib URL", murle);
        }
        HashSet<URL> urls = new HashSet<URL>();
        for (String bootLib : JBOSS_LIB_BOOT_LIST) {
            URI uri;
            URL url;
            try {
                url = new URL(jbossLib, bootLib);
            }
            catch (MalformedURLException murle) {
                throw new RuntimeException("Could not construct full URL for $JBOSS_HOME boot library: " + bootLib, murle);
            }
            urls.add(url);
            log.finer("Using: " + url);
            try {
                uri = url.toURI();
            }
            catch (URISyntaxException urise) {
                throw new RuntimeException(urise);
            }
            File file = new File(uri);
            if (file.exists()) continue;
            throw new IllegalStateException("Attempting to add a library to the ClassLoader which does not exist: " + file + "; perhaps a corrupt $JBOSS_HOME installation? ");
        }
        log.fine("Using: " + urls);
        return urls.toArray(new URL[0]);
    }
}

