/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.deployer;

import java.util.Map;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.Deployer;
import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.deployers.spi.managed.ManagedObjectBuilder;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployerWrapper
implements Deployer,
ManagedObjectBuilder {
    private Logger log;
    private Deployer deployer;
    private ManagedObjectBuilder managedObjectBuilder;

    public DeployerWrapper(Deployer deployer) {
        if (deployer == null) {
            throw new IllegalArgumentException("Null deployer");
        }
        this.deployer = deployer;
        this.log = Logger.getLogger(deployer.getClass());
        if (deployer instanceof ManagedObjectBuilder) {
            this.managedObjectBuilder = (ManagedObjectBuilder)((Object)deployer);
        }
    }

    public ManagedObjectBuilder getManagedObjectBuilder() {
        return this.managedObjectBuilder;
    }

    public void setManagedObjectBuilder(ManagedObjectBuilder managedObjectBuilder) {
        this.managedObjectBuilder = managedObjectBuilder;
    }

    @Override
    public String getType() {
        return this.deployer.getType();
    }

    @Override
    public boolean isRelevant(DeploymentUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Null unit");
        }
        try {
            boolean result = this.deployer.isRelevant(unit);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("isRelevant " + unit.getName() + " result=" + result));
            }
            return result;
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error during isRelevant: " + unit.getName()), t);
            return false;
        }
    }

    @Override
    public void prepareDeploy(DeploymentUnit unit) throws DeploymentException {
        if (unit == null) {
            throw new IllegalArgumentException("Null unit");
        }
        try {
            this.log.trace((Object)("Preparing deployment: " + unit.getName()));
            this.deployer.prepareDeploy(unit);
            this.log.trace((Object)("Prepared deployment:  " + unit.getName()));
        }
        catch (Throwable t) {
            this.log.error((Object)("Error during prepare deployment: " + unit.getName()), t);
            throw DeploymentException.rethrowAsDeploymentException("Error during prepare deployment: " + unit.getName(), t);
        }
    }

    @Override
    public void prepareUndeploy(DeploymentUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Null unit");
        }
        try {
            this.log.trace((Object)("Undeploying: " + unit.getName()));
            this.deployer.prepareUndeploy(unit);
            this.log.trace((Object)("Undeployed:  " + unit.getName()));
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error during undeployment: " + unit.getName()), t);
        }
    }

    @Override
    public void handoff(DeploymentUnit from, DeploymentUnit to) throws DeploymentException {
        if (from == null) {
            throw new IllegalArgumentException("Null from deployment");
        }
        if (to == null) {
            throw new IllegalArgumentException("Null to deployment");
        }
        try {
            this.log.trace((Object)("Handing off from=" + from.getName() + " to=" + to.getName()));
            this.deployer.handoff(from, to);
            this.log.trace((Object)("Handed off from=" + from.getName() + " to=" + to.getName()));
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error during handoff from=" + from.getName() + " to=" + to.getName()), t);
            throw DeploymentException.rethrowAsDeploymentException("Error during handoff from=" + from.getName() + " to=" + to.getName(), t);
        }
    }

    @Override
    public void commitDeploy(DeploymentUnit unit) throws DeploymentException {
        if (unit == null) {
            throw new IllegalArgumentException("Null unit");
        }
        try {
            this.log.trace((Object)("Deploying: " + unit.getName()));
            this.deployer.commitDeploy(unit);
            this.log.trace((Object)("Deployed:  " + unit.getName()));
        }
        catch (Throwable t) {
            this.log.error((Object)("Error during deployment: " + unit.getName()), t);
            throw DeploymentException.rethrowAsDeploymentException("Error during deployment: " + unit.getName(), t);
        }
    }

    @Override
    public void commitUndeploy(DeploymentUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Null unit");
        }
        try {
            this.log.trace((Object)("Commiting undeployment: " + unit.getName()));
            this.deployer.commitUndeploy(unit);
            this.log.trace((Object)("Commited undeployment:  " + unit.getName()));
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error during commit undeployment: " + unit.getName()), t);
        }
    }

    @Override
    public int getRelativeOrder() {
        return this.deployer.getRelativeOrder();
    }

    @Override
    public void setRelativeOrder(int order) {
        this.deployer.setRelativeOrder(order);
    }

    @Override
    public void build(DeploymentUnit unit, Map<String, ManagedObject> managedObjects) throws DeploymentException {
        if (this.managedObjectBuilder == null) {
            return;
        }
        if (unit == null) {
            throw new IllegalArgumentException("Null unit");
        }
        if (managedObjects == null) {
            throw new IllegalArgumentException("Null managed objects");
        }
        try {
            this.log.trace((Object)("build: " + unit.getName()));
            this.managedObjectBuilder.build(unit, managedObjects);
            this.log.trace((Object)("built: " + unit.getName()));
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error during commit undeployment: " + unit.getName()), t);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Deployer)) {
            return false;
        }
        if (obj instanceof DeployerWrapper) {
            obj = ((DeployerWrapper)obj).deployer;
        }
        return this.deployer.equals(obj);
    }

    public int hashCode() {
        return this.deployer.hashCode();
    }

    public String toString() {
        return this.deployer.toString();
    }
}

