/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.lucene.store;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.lucene.store.DirectoryProvider;
import org.hibernate.lucene.store.DirectoryProviderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSDirectoryProvider
implements DirectoryProvider<FSDirectory> {
    private FSDirectory directory;
    private static Log log = LogFactory.getLog(FSDirectoryProvider.class);
    private String indexName;

    @Override
    public void initialize(Class entity, Configuration cfg, Properties properties) {
        String indexBase = properties.getProperty("indexBase", ".");
        File indexDir = new File(indexBase);
        if (!indexDir.exists() || !indexDir.isDirectory()) {
            throw new HibernateException(MessageFormat.format("Index directory does not exists: {0}", indexBase));
        }
        if (!indexDir.canWrite()) {
            throw new HibernateException("Cannot write into index directory: " + indexBase);
        }
        log.info((Object)("Setting index dir to " + indexDir));
        String fileName = DirectoryProviderFactory.getTypeName(entity);
        File file = new File(indexDir, fileName);
        try {
            boolean create = !file.exists();
            this.indexName = file.getCanonicalPath();
            this.directory = FSDirectory.getDirectory((String)this.indexName, (boolean)create);
            if (create) {
                IndexWriter iw = new IndexWriter((Directory)this.directory, (Analyzer)new StandardAnalyzer(), create);
                iw.close();
            }
        }
        catch (IOException e) {
            throw new HibernateException("Unable to initialize index: " + fileName, e);
        }
    }

    @Override
    public FSDirectory getDirectory() {
        return this.directory;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof FSDirectoryProvider)) {
            return false;
        }
        return this.indexName.equals(((FSDirectoryProvider)obj).indexName);
    }

    public int hashCode() {
        return this.indexName.hashCode();
    }
}

