/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.tools.content;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.jboss.elasticsearch.tools.content.StructureUtils;
import org.jboss.elasticsearch.tools.content.StructuredContentPreprocessorBase;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class StripHtmlPreprocessor
extends StructuredContentPreprocessorBase {
    protected static final String CFG_SOURCE_FIELD = "source_field";
    protected static final String CFG_TARGET_FIELD = "target_field";
    protected static final String CFG_source_bases = "source_bases";
    protected String fieldSource;
    protected String fieldTarget;
    protected List<String> sourceBases;

    @Override
    public void init(Map<String, Object> settings) throws SettingsException {
        if (settings == null) {
            throw new SettingsException("'settings' section is not defined for preprocessor " + this.name);
        }
        this.fieldSource = XContentMapValues.nodeStringValue((Object)settings.get(CFG_SOURCE_FIELD), null);
        this.validateConfigurationStringNotEmpty(this.fieldSource, CFG_SOURCE_FIELD);
        this.fieldTarget = XContentMapValues.nodeStringValue((Object)settings.get(CFG_TARGET_FIELD), null);
        this.validateConfigurationStringNotEmpty(this.fieldTarget, CFG_TARGET_FIELD);
        this.sourceBases = (List)settings.get(CFG_source_bases);
    }

    @Override
    public Map<String, Object> preprocessData(Map<String, Object> data) {
        if (data == null) {
            return null;
        }
        if (this.sourceBases == null) {
            this.processOneSourceValue(data);
        } else {
            for (String base : this.sourceBases) {
                Object obj = XContentMapValues.extractValue((String)base, data);
                if (obj == null) continue;
                if (obj instanceof Map) {
                    this.processOneSourceValue((Map)obj);
                    continue;
                }
                if (obj instanceof Collection) {
                    for (Object o : (Collection)obj) {
                        if (o instanceof Map) {
                            this.processOneSourceValue((Map)o);
                            continue;
                        }
                        this.logger.warn("Source base {} contains collection with invalid value to be processed {}", new Object[]{base, obj});
                    }
                    continue;
                }
                this.logger.warn("Source base {} contains invalid value to be processed {}", new Object[]{base, obj});
            }
        }
        return data;
    }

    private void processOneSourceValue(Map<String, Object> data) {
        Object v = null;
        v = this.fieldSource.contains(".") ? XContentMapValues.extractValue((String)this.fieldSource, data) : data.get(this.fieldSource);
        if (v != null) {
            if (!(v instanceof String)) {
                this.logger.warn("value for field '" + this.fieldSource + "' is not String, so can't be processed by '" + this.name + "' preprocessor", new Object[0]);
            } else {
                String value = this.stripHtml(v.toString());
                StructureUtils.putValueIntoMapOfMaps(data, this.fieldTarget, value);
            }
        }
    }

    protected String stripHtml(String value) {
        if (value == null || value.trim().isEmpty()) {
            return value;
        }
        Document doc = Jsoup.parse((String)value);
        return doc.text();
    }

    public String getFieldSource() {
        return this.fieldSource;
    }

    public String getFieldTarget() {
        return this.fieldTarget;
    }

    public List<String> getSourceBases() {
        return this.sourceBases;
    }
}

