/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.tools.content;

import java.util.Map;
import org.elasticsearch.common.joda.time.format.DateTimeFormatter;
import org.elasticsearch.common.joda.time.format.ISODateTimeFormat;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.jboss.elasticsearch.tools.content.StructureUtils;
import org.jboss.elasticsearch.tools.content.StructuredContentPreprocessorBase;

public class MaxTimestampPreprocessor
extends StructuredContentPreprocessorBase {
    protected static final String CFG_TARGET_FIELD = "target_field";
    protected static final String CFG_SOURCE_FIELD = "source_field";
    protected String fieldTarget;
    protected String fieldSource;

    @Override
    public void init(Map<String, Object> settings) throws SettingsException {
        if (settings == null) {
            throw new SettingsException("'settings' section is not defined for preprocessor " + this.name);
        }
        this.fieldTarget = XContentMapValues.nodeStringValue((Object)settings.get(CFG_TARGET_FIELD), null);
        this.fieldSource = XContentMapValues.nodeStringValue((Object)settings.get(CFG_SOURCE_FIELD), null);
        this.validateConfigurationStringNotEmpty(this.fieldSource, CFG_SOURCE_FIELD);
        this.validateConfigurationStringNotEmpty(this.fieldTarget, CFG_TARGET_FIELD);
    }

    @Override
    public Map<String, Object> preprocessData(Map<String, Object> data) {
        if (data == null) {
            return null;
        }
        String maxTimestamp = null;
        long maxTimestampParsed = 0L;
        Object sourceData = XContentMapValues.extractValue((String)this.fieldSource, data);
        if (sourceData != null) {
            DateTimeFormatter dateParser = ISODateTimeFormat.dateTimeParser();
            if (sourceData instanceof Iterable) {
                for (Object o : (Iterable)sourceData) {
                    if (!(o instanceof String)) continue;
                    try {
                        long timestampParsed;
                        String timestamp = (String)o;
                        if (timestamp == null || timestamp.trim().isEmpty() || (timestampParsed = dateParser.parseMillis(timestamp.trim())) <= maxTimestampParsed) continue;
                        maxTimestampParsed = timestampParsed;
                        maxTimestamp = timestamp;
                    }
                    catch (Exception e) {
                        this.logger.debug("Value {} is not valid timestamp", new Object[]{0});
                    }
                }
            } else if (sourceData instanceof String) {
                try {
                    String timestamp = (String)sourceData;
                    if (timestamp != null && !timestamp.trim().isEmpty()) {
                        timestamp = timestamp.trim();
                        dateParser.parseMillis(timestamp);
                        maxTimestamp = timestamp;
                    }
                }
                catch (Exception e) {
                    this.logger.debug("Value {} is not valid timestamp", new Object[]{0});
                }
            } else {
                this.logger.debug("Value for field {} is not Iterable nor String but is {}", new Object[]{this.fieldSource, sourceData.getClass().getName()});
            }
        } else {
            this.logger.debug("Value for field {} not found in data", new Object[]{this.fieldSource});
        }
        this.logger.debug("Max timestamp found in {} is {}", new Object[]{this.fieldSource, maxTimestamp});
        StructureUtils.putValueIntoMapOfMaps(data, this.fieldTarget, maxTimestamp);
        return data;
    }
}

