/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.tools.content;

import java.util.Map;
import org.elasticsearch.common.joda.time.format.ISODateTimeFormat;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.jboss.elasticsearch.tools.content.StructureUtils;
import org.jboss.elasticsearch.tools.content.StructuredContentPreprocessorBase;

public class AddCurrentTimestampPreprocessor
extends StructuredContentPreprocessorBase {
    protected static final String CFG_FIELD = "field";
    protected String field;

    @Override
    public void init(Map<String, Object> settings) throws SettingsException {
        if (settings == null) {
            throw new SettingsException("'settings' section is not defined for preprocessor " + this.name);
        }
        this.field = XContentMapValues.nodeStringValue((Object)settings.get(CFG_FIELD), null);
        this.validateConfigurationStringNotEmpty(this.field, CFG_FIELD);
    }

    @Override
    public Map<String, Object> preprocessData(Map<String, Object> data) {
        if (data == null) {
            return null;
        }
        StructureUtils.putValueIntoMapOfMaps(data, this.field, ISODateTimeFormat.dateTime().print(System.currentTimeMillis()));
        return data;
    }
}

