/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.river.sysinfo;

import org.elasticsearch.common.settings.SettingsException;
import org.jboss.elasticsearch.river.sysinfo.Utils;

public enum SysinfoType {
    CLUSTER_HEALTH("cluster_health"),
    CLUSTER_STATE("cluster_state"),
    CLUSTER_NODES_INFO("cluster_nodes_info"),
    CLUSTER_NODES_STATS("cluster_nodes_stats"),
    INDICES_STATUS("indices_status"),
    INDICES_STATS("indices_stats"),
    INDICES_SEGMENTS("indices_segments");

    private String name;

    private SysinfoType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static SysinfoType parseConfiguration(String value) throws SettingsException {
        if (Utils.isEmpty(value)) {
            throw new SettingsException("indexers/info_type must be defined");
        }
        for (SysinfoType t : SysinfoType.values()) {
            if (!t.getName().equalsIgnoreCase(value)) continue;
            return t;
        }
        throw new SettingsException("indexers/info_type contains unsupported name: " + value);
    }
}

