/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timerservice.deployer;

import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.common.deployers.spi.AttachmentNames;
import org.jboss.ejb3.timerservice.deployer.AutoTimerInitializer;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;

public class TimerServiceDeployer
extends AbstractDeployer {
    private Logger logger = Logger.getLogger(TimerServiceDeployer.class);
    private static final String MC_BEAN_PREFIX = "auto-timer-initializer:";

    public TimerServiceDeployer() {
        this.setStage(DeploymentStages.REAL);
        this.setInput(JBossMetaData.class);
        this.addInput(AttachmentNames.PROCESSED_METADATA);
        this.addOutput(BeanMetaData.class);
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        JBossMetaData metaData;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Deploying unit " + unit.getName()));
        }
        if ((metaData = (JBossMetaData)unit.getAttachment(AttachmentNames.PROCESSED_METADATA, JBossMetaData.class)) == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("No JBossMetadata for unit : " + unit.getName()));
            }
            return;
        }
        if (!metaData.isEJB3x()) {
            return;
        }
        JBossEnterpriseBeansMetaData beans = metaData.getEnterpriseBeans();
        for (JBossEnterpriseBeanMetaData bean : beans) {
            JBossSessionBeanMetaData sessionBean;
            if (bean.isSession() ? (sessionBean = (JBossSessionBeanMetaData)bean).isStateful() : bean.isEntity() || bean.isService()) continue;
            String mcBeanName = MC_BEAN_PREFIX + unit.getName() + "$" + bean.getEjbName();
            BeanMetaData bmd = this.createAutoTimerInitializer(mcBeanName, bean);
            unit.addAttachment(BeanMetaData.class + ":" + mcBeanName, (Object)bmd);
        }
    }

    private BeanMetaData createAutoTimerInitializer(String mcBeanName, JBossEnterpriseBeanMetaData bean) {
        AutoTimerInitializer autoTimerInitializer = new AutoTimerInitializer();
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)mcBeanName, (String)autoTimerInitializer.getClass().getName());
        builder.setConstructorValue((Object)autoTimerInitializer);
        AbstractInjectionValueMetaData injectMetaData = new AbstractInjectionValueMetaData((Object)bean.getContainerName());
        injectMetaData.setDependentState(ControllerState.INSTALLED);
        builder.addPropertyMetaData("container", (ValueMetaData)injectMetaData);
        return builder.getBeanMetaData();
    }
}

