/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.metrics.deployer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.spi.deployer.managed.ManagedObjectCreator;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.javaee.JavaEEApplication;
import org.jboss.ejb3.mdb.MessagingContainer;
import org.jboss.ejb3.metrics.deployer.BasicMessageDrivenMetrics;
import org.jboss.ejb3.metrics.deployer.BasicStatefulSessionInstanceMetrics;
import org.jboss.ejb3.metrics.deployer.BasicStatelessSessionInstanceMetrics;
import org.jboss.ejb3.metrics.deployer.ManagedInvocationStatisticsSessionWrapperBase;
import org.jboss.ejb3.metrics.deployer.ManagedStatefulInvocationStatisticsWrapper;
import org.jboss.ejb3.metrics.deployer.ManagedStatelessInvocationStatisticsWrapper;
import org.jboss.ejb3.metrics.spi.SessionInstanceMetrics;
import org.jboss.ejb3.session.SessionContainer;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ejb3.stateless.StatelessContainer;
import org.jboss.ejb3.statistics.InvocationStatistics;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployment;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.metadata.spi.MetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3MetricsDeployer
extends AbstractSimpleRealDeployer<Ejb3Deployment>
implements ManagedObjectCreator {
    private static final Logger log = Logger.getLogger(Ejb3MetricsDeployer.class);
    public static final String NAME_OUTPUT = Ejb3MetricsDeployer.class.getName();
    private static final String BEAN_NAME_METRICS_SUFFIX = "-metrics";
    private static final String BEAN_NAME_METRICS_SUFFIX_INSTANCE = "-metrics-instance";
    private static final String BEAN_NAME_METRICS_SUFFIX_INVOCATION = "-metrics-invocation";
    private ManagedObjectFactory managedObjectFactory = ManagedObjectFactory.getInstance();

    public Ejb3MetricsDeployer() {
        super(Ejb3Deployment.class);
        this.addOutput(NAME_OUTPUT);
    }

    public void deploy(DeploymentUnit du, Ejb3Deployment deployment) throws DeploymentException {
        Collection containers;
        if (deployment == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Skipping non-EJB3 Deployment: " + du));
            }
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Deploying EJB3 Session metrics for : " + du));
        }
        if ((containers = deployment.getEjbContainers().values()) != null) {
            AbstractKernelDeployment kernelDeployment = new AbstractKernelDeployment();
            ArrayList<BeanMetaDataFactory> beanFactories = new ArrayList<BeanMetaDataFactory>();
            kernelDeployment.setBeanFactories(beanFactories);
            for (Container container : containers) {
                String ejbName = container.getEjbName();
                JavaEEApplication application = deployment.getApplication();
                if (application != null) {
                    ejbName = application.getName() + "-" + ejbName;
                }
                if (container instanceof SessionContainer) {
                    String beanName;
                    ManagedInvocationStatisticsSessionWrapperBase invocationMetrics;
                    SessionInstanceMetrics metrics;
                    SessionContainer sessionContainer = (SessionContainer)container;
                    InvocationStatistics stats = sessionContainer.getInvokeStats();
                    if (stats == null) {
                        throw new IllegalStateException("Invocation statistics was null");
                    }
                    String invocationBeanName = ejbName + BEAN_NAME_METRICS_SUFFIX_INVOCATION;
                    if (sessionContainer instanceof StatelessContainer) {
                        StatelessContainer slsb = (StatelessContainer)sessionContainer;
                        metrics = new BasicStatelessSessionInstanceMetrics(slsb);
                        invocationMetrics = new ManagedStatelessInvocationStatisticsWrapper(stats);
                        beanName = ejbName + BEAN_NAME_METRICS_SUFFIX_INSTANCE;
                        this.attach(metrics, beanName, beanFactories);
                        log.debug((Object)("Attached metrics stats for: " + beanName));
                        this.attach(invocationMetrics, invocationBeanName, beanFactories);
                        log.debug((Object)("Attached invocation stats for: " + invocationBeanName));
                        continue;
                    }
                    if (!(sessionContainer instanceof StatefulContainer)) continue;
                    StatefulContainer sfsb = (StatefulContainer)sessionContainer;
                    metrics = new BasicStatefulSessionInstanceMetrics(sfsb);
                    invocationMetrics = new ManagedStatefulInvocationStatisticsWrapper(stats);
                    beanName = ejbName + BEAN_NAME_METRICS_SUFFIX_INSTANCE;
                    this.attach(metrics, beanName, beanFactories);
                    log.debug((Object)("Attached metrics stats for: " + beanName));
                    this.attach(invocationMetrics, invocationBeanName, beanFactories);
                    log.debug((Object)("Attached invocation stats for: " + invocationBeanName));
                    continue;
                }
                if (!(container instanceof MessagingContainer)) continue;
                MessagingContainer mdb = (MessagingContainer)container;
                BasicMessageDrivenMetrics metrics = new BasicMessageDrivenMetrics(mdb);
                String beanName = ejbName + BEAN_NAME_METRICS_SUFFIX_INSTANCE;
                this.attach(metrics, beanName, beanFactories);
                log.debug((Object)("Attached metrics stats for: " + beanName));
            }
            du.addAttachment(NAME_OUTPUT, (Object)kernelDeployment, KernelDeployment.class);
        }
    }

    public void build(DeploymentUnit unit, Set<String> attachmentNames, Map<String, ManagedObject> managedObjects) throws DeploymentException {
        KernelDeployment deployment = (KernelDeployment)unit.getAttachment(NAME_OUTPUT, KernelDeployment.class);
        if (deployment != null) {
            for (BeanMetaData bmd : deployment.getBeans()) {
                ManagedObject mo;
                MetaData metaData = null;
                DeploymentUnit compUnit = unit.getComponent(bmd.getName());
                if (compUnit != null) {
                    metaData = compUnit.getMetaData();
                }
                if ((mo = this.managedObjectFactory.initManagedObject((Object)bmd, null, metaData, bmd.getName(), null)) == null) continue;
                managedObjects.put(bmd.getName(), mo);
            }
        }
    }

    private void attach(Object attachment, String beanName, List<BeanMetaDataFactory> beanFactories) throws IllegalArgumentException {
        if (attachment == null) {
            throw new IllegalArgumentException("metrics is null");
        }
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(beanName, attachment.getClass().getName());
        AbstractConstructorMetaData cmd = new AbstractConstructorMetaData();
        cmd.setValue((ValueMetaData)new AbstractValueMetaData(attachment));
        bmd.setConstructor((ConstructorMetaData)cmd);
        beanFactories.add((BeanMetaDataFactory)bmd);
        log.info((Object)("Attaching MC Bean: " + beanName));
    }
}

