/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.mcint.metadata.plugins;

import java.util.Iterator;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.main.MainDeployerStructure;
import org.jboss.ejb3.common.deployers.spi.AttachmentNames;
import org.jboss.ejb3.common.registrar.spi.Ejb3RegistrarLocator;
import org.jboss.ejb3.common.resolvers.spi.EjbReference;
import org.jboss.ejb3.common.resolvers.spi.EjbReferenceResolver;
import org.jboss.ejb3.common.resolvers.spi.UnresolvableReferenceException;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.reflect.spi.TypeInfo;

public class AbstractEjbReferenceValueMetadata
extends AbstractDependencyValueMetaData {
    private static final long serialVersionUID = 1L;
    private static final String MC_BEAN_NAME_MAIN_DEPLOYER = "MainDeployer";
    private static final String DEPENDS_JNDI_PREFIX = "jndi:";
    private EjbReferenceResolver resolver;
    private EjbReference reference;
    private Context namingContext;

    public AbstractEjbReferenceValueMetadata(EjbReferenceResolver resolver, EjbReference reference, Context context) {
        assert (resolver != null) : "Resolver is required, but was not specified";
        assert (reference != null) : "EJB Reference is required, but was not specified";
        assert (context != null) : "Naming Context is required, but was not specified";
        this.setResolver(resolver);
        this.setReference(reference);
        this.setNamingContext(context);
    }

    public Object getValue(TypeInfo info, ClassLoader cl) throws Throwable {
        return this.resolveEjb();
    }

    public Object getValue() {
        return this.resolveEjb();
    }

    public Object getUnderlyingValue() {
        return DEPENDS_JNDI_PREFIX + this.getTargetJndiName();
    }

    protected String getTargetJndiName() {
        Deployment d;
        DeploymentUnit du;
        String jndiName = null;
        Object mainDeployer = Ejb3RegistrarLocator.locateRegistrar().lookup((Object)MC_BEAN_NAME_MAIN_DEPLOYER);
        assert (mainDeployer instanceof DeployerClient && mainDeployer instanceof MainDeployerStructure) : "Obtained Main Deployer is not of expected type";
        DeployerClient dc = (DeployerClient)mainDeployer;
        MainDeployerStructure mds = (MainDeployerStructure)mainDeployer;
        Iterator i$ = dc.getTopLevel().iterator();
        while (i$.hasNext() && ((du = mds.getDeploymentUnit((d = (Deployment)i$.next()).getName())).getAttachment(AttachmentNames.PROCESSED_METADATA, JBossMetaData.class) == null || (jndiName = this.resolver.resolveEjb(du, this.reference)) == null)) {
        }
        if (jndiName == null) {
            throw new UnresolvableReferenceException("Could not resolve in current deployments reference: " + this.reference);
        }
        return jndiName;
    }

    protected Object resolveEjb() {
        Object obj = null;
        String jndiName = this.getTargetJndiName();
        try {
            obj = this.getNamingContext().lookup(jndiName);
        }
        catch (NamingException e) {
            throw new RuntimeException("Could not obtain " + jndiName + "from JNDI", e);
        }
        this.addDependencyItem();
        return obj;
    }

    public EjbReference getReference() {
        return this.reference;
    }

    protected void setReference(EjbReference reference) {
        this.reference = reference;
    }

    protected EjbReferenceResolver getResolver() {
        return this.resolver;
    }

    protected void setResolver(EjbReferenceResolver resolver) {
        this.resolver = resolver;
    }

    protected Context getNamingContext() {
        return this.namingContext;
    }

    protected void setNamingContext(Context context) {
        this.namingContext = context;
    }
}

