/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.endpoint.reflect;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import org.jboss.ejb3.endpoint.Endpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointInvocationHandler
implements InvocationHandler {
    private static final Method METHOD_EQUALS;
    private static final Method METHOD_HASH_CODE;
    private static final Method METHOD_TO_STRING;
    private Endpoint endpoint;
    private Serializable session;
    private Class<?> invokedBusinessInterface;

    public EndpointInvocationHandler(Endpoint endpoint, Serializable session, Class<?> invokedBusinessInterface) {
        assert (endpoint != null) : "endpoint is null";
        this.endpoint = endpoint;
        this.session = session;
        this.invokedBusinessInterface = invokedBusinessInterface;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (Proxy.isProxyClass(obj.getClass())) {
            return this.equals(Proxy.getInvocationHandler(obj));
        }
        if (!(obj instanceof EndpointInvocationHandler)) {
            return obj.equals(this);
        }
        EndpointInvocationHandler other = (EndpointInvocationHandler)obj;
        if (!other.endpoint.equals(this.endpoint)) {
            return false;
        }
        if (!EndpointInvocationHandler.equals(other.session, this.session)) {
            return false;
        }
        return EndpointInvocationHandler.equals(other.invokedBusinessInterface, this.invokedBusinessInterface);
    }

    private static boolean equals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public int hashCode() {
        int hashCode = this.endpoint.hashCode();
        if (this.session != null) {
            hashCode += this.session.hashCode() << 2;
        }
        if (this.invokedBusinessInterface != null) {
            hashCode += this.invokedBusinessInterface.hashCode() << 4;
        }
        return hashCode;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.equals(METHOD_EQUALS)) {
            return this.equals(args[0]);
        }
        if (method.equals(METHOD_HASH_CODE)) {
            return this.hashCode();
        }
        if (method.equals(METHOD_TO_STRING)) {
            return this.toProxyString();
        }
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        return this.endpoint.invoke(this.session, contextData, this.invokedBusinessInterface, method, args);
    }

    public String toProxyString() {
        return "Proxy on " + this.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append("{endpoint=" + this.endpoint);
        sb.append(",invokedBusinessInterface=" + this.invokedBusinessInterface);
        sb.append(",session=" + this.session);
        sb.append("}");
        return sb.toString();
    }

    static {
        try {
            METHOD_EQUALS = Object.class.getDeclaredMethod("equals", Object.class);
            METHOD_HASH_CODE = Object.class.getDeclaredMethod("hashCode", new Class[0]);
            METHOD_TO_STRING = Object.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

