/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.deployers.metadata.processor;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.process.ProcessingException;
import org.jboss.metadata.process.processor.JBossMetaDataProcessor;

public class ContainerNameMetaDataProcessor
implements JBossMetaDataProcessor<JBossMetaData> {
    private static Logger logger = Logger.getLogger(ContainerNameMetaDataProcessor.class);
    private DeploymentUnit deploymentUnit;

    public ContainerNameMetaDataProcessor(DeploymentUnit deploymentUnit) {
        this.deploymentUnit = deploymentUnit;
    }

    public JBossMetaData process(JBossMetaData metadata) throws ProcessingException {
        if (!metadata.isEJB3x()) {
            return metadata;
        }
        JBossEnterpriseBeansMetaData enterpriseBeans = metadata.getEnterpriseBeans();
        if (enterpriseBeans == null || enterpriseBeans.isEmpty()) {
            return metadata;
        }
        for (JBossEnterpriseBeanMetaData enterpriseBean : enterpriseBeans) {
            String containerName;
            if (enterpriseBean.getContainerName() != null) continue;
            try {
                containerName = this.getContainerName(this.deploymentUnit, enterpriseBean);
            }
            catch (MalformedObjectNameException moe) {
                throw new ProcessingException("Could not generate a container name for bean " + enterpriseBean.getEjbName(), (Throwable)moe);
            }
            enterpriseBean.setContainerName(containerName);
        }
        return metadata;
    }

    private String getContainerName(DeploymentUnit unit, JBossEnterpriseBeanMetaData enterpriseBeanMetaData) throws MalformedObjectNameException {
        StringBuilder containerName = new StringBuilder("jboss.j2ee:service=EJB3,");
        DeploymentUnit toplevelUnit = unit.getTopLevel();
        if (toplevelUnit != null && this.isEar(toplevelUnit)) {
            containerName.append("ear=");
            containerName.append(toplevelUnit.getSimpleName());
            containerName.append(",");
        }
        if (unit.getSimpleName() == null) {
            containerName.append("*");
        } else {
            containerName.append("jar=");
            containerName.append(unit.getSimpleName());
        }
        containerName.append(",name=");
        containerName.append(enterpriseBeanMetaData.getEjbName());
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Container name generated for ejb = " + enterpriseBeanMetaData.getEjbName() + " in unit " + unit + " is " + containerName));
        }
        ObjectName containerJMXName = new ObjectName(containerName.toString());
        return containerJMXName.getCanonicalName();
    }

    private boolean isEar(DeploymentUnit unit) {
        return unit.getSimpleName().endsWith(".ear") || unit.getAttachment(JBossAppMetaData.class) != null;
    }
}

