/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.asynch;

import java.lang.reflect.InvocationTargetException;
import org.jboss.aop.Dispatcher;
import org.jboss.aspects.asynch.Future;
import org.jboss.aspects.asynch.RemotableFuture;
import org.jboss.aspects.asynch.TimeoutException;
import org.jboss.util.id.GUID;

public class FutureImpl
implements RemotableFuture {
    private Future result;
    private GUID remoteObjectID;

    public FutureImpl(Future result) {
        this.result = result;
    }

    public void setRemoteObjectID(GUID remoteObjectID) {
        this.remoteObjectID = remoteObjectID;
    }

    public void release() {
        if (this.remoteObjectID != null) {
            Dispatcher.singleton.unregisterTarget((Object)this.remoteObjectID);
        }
    }

    public Object get() throws InterruptedException, InvocationTargetException {
        try {
            Object rtn = this.result.get();
            this.release();
            return rtn;
        }
        catch (InvocationTargetException e) {
            this.release();
            throw e;
        }
    }

    public Object get(long milliseconds) throws TimeoutException, InterruptedException, InvocationTargetException {
        try {
            Object rtn = this.result.get(milliseconds);
            this.release();
            return rtn;
        }
        catch (TimeoutException e) {
            throw new TimeoutException(e);
        }
        catch (InvocationTargetException e) {
            this.release();
            throw e;
        }
    }

    public boolean isDone() {
        return this.result.isDone();
    }
}

