/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.sequencer.java.metadata;

import java.io.InputStream;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.dna.common.monitor.ProgressMonitor;
import org.jboss.dna.sequencer.java.AbstractJavaMetadata;
import org.jboss.dna.sequencer.java.CompilationUnitParser;
import org.jboss.dna.sequencer.java.JavaMetadataUtil;
import org.jboss.dna.sequencer.java.metadata.ImportMetadata;
import org.jboss.dna.sequencer.java.metadata.PackageMetadata;
import org.jboss.dna.sequencer.java.metadata.TypeMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMetadata
extends AbstractJavaMetadata {
    private PackageMetadata packageMetadata;
    private List<ImportMetadata> imports;
    private List<TypeMetadata> types;

    private JavaMetadata() {
    }

    public static JavaMetadata instance(InputStream inputStream, long length, String encoding, ProgressMonitor progressMonitor) {
        JavaMetadata javaMetadata = new JavaMetadata();
        char[] source = null;
        try {
            source = JavaMetadataUtil.getJavaSourceFromTheInputStream(inputStream, length, encoding);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        CompilationUnit unit = (CompilationUnit)CompilationUnitParser.runJLS3Conversion(source, true);
        if (unit != null) {
            javaMetadata.packageMetadata = javaMetadata.createPackageMetadata(unit);
            javaMetadata.imports = javaMetadata.createImportMetadata(unit);
            javaMetadata.types = javaMetadata.createTypeMetadata(unit);
        }
        return javaMetadata;
    }

    public final PackageMetadata getPackageMetadata() {
        return this.packageMetadata;
    }

    public List<ImportMetadata> getImports() {
        return this.imports;
    }

    public List<TypeMetadata> getTypeMetadata() {
        return this.types;
    }
}

