/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.properties.NamespaceRegistry;
import org.jboss.dna.graph.properties.basic.BasicNamespace;
import org.jboss.dna.repository.util.SessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrNamespaceRegistry
implements NamespaceRegistry {
    private final String repositoryWorkspaceName;
    private final SessionFactory sessionFactory;

    public JcrNamespaceRegistry(SessionFactory sessionFactory, String repositoryWorkspaceName) {
        CheckArg.isNotNull((Object)sessionFactory, (String)"sessionFactory");
        CheckArg.isNotNull((Object)repositoryWorkspaceName, (String)"repositoryWorkspaceName");
        this.repositoryWorkspaceName = repositoryWorkspaceName;
        this.sessionFactory = sessionFactory;
    }

    public String getDefaultNamespaceUri() {
        String string;
        block4: {
            Session session = null;
            try {
                session = this.sessionFactory.createSession(this.repositoryWorkspaceName);
                string = session.getNamespaceURI("");
                Object var4_4 = null;
                if (session == null) break block4;
            }
            catch (RepositoryException e) {
                try {
                    throw new org.jboss.dna.graph.properties.NamespaceException((Throwable)e);
                }
                catch (Throwable throwable) {
                    block5: {
                        Object var4_5 = null;
                        if (session == null) break block5;
                        session.logout();
                    }
                    throw throwable;
                }
            }
            session.logout();
        }
        return string;
    }

    public String getNamespaceForPrefix(String prefix) {
        String string;
        block4: {
            Session session = null;
            try {
                session = this.sessionFactory.createSession(this.repositoryWorkspaceName);
                string = session.getNamespaceURI(prefix);
                Object var5_5 = null;
                if (session == null) break block4;
            }
            catch (RepositoryException e) {
                try {
                    throw new org.jboss.dna.graph.properties.NamespaceException((Throwable)e);
                }
                catch (Throwable throwable) {
                    block5: {
                        Object var5_6 = null;
                        if (session == null) break block5;
                        session.logout();
                    }
                    throw throwable;
                }
            }
            session.logout();
        }
        return string;
    }

    public String getPrefixForNamespaceUri(String namespaceUri, boolean generateIfMissing) {
        String string;
        block4: {
            Session session = null;
            try {
                session = this.sessionFactory.createSession(this.repositoryWorkspaceName);
                string = session.getNamespacePrefix(namespaceUri);
                Object var6_6 = null;
                if (session == null) break block4;
            }
            catch (RepositoryException e) {
                try {
                    throw new org.jboss.dna.graph.properties.NamespaceException((Throwable)e);
                }
                catch (Throwable throwable) {
                    block5: {
                        Object var6_7 = null;
                        if (session == null) break block5;
                        session.logout();
                    }
                    throw throwable;
                }
            }
            session.logout();
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isRegisteredNamespaceUri(String namespaceUri) {
        boolean bl;
        Session session = null;
        try {
            try {
                session = this.sessionFactory.createSession(this.repositoryWorkspaceName);
                session.getNamespacePrefix(namespaceUri);
                bl = true;
                Object var6_6 = null;
                if (session == null) return bl;
            }
            catch (NamespaceException e) {
                boolean bl2 = false;
                Object var6_7 = null;
                if (session == null) return bl2;
                session.logout();
                return bl2;
            }
            catch (RepositoryException e) {
                throw new org.jboss.dna.graph.properties.NamespaceException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (session == null) throw throwable;
            session.logout();
            throw throwable;
        }
        session.logout();
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String register(String prefix, String namespaceUri) {
        String previousNamespaceUriForPrefix = null;
        Session session = null;
        try {
            try {
                session = this.sessionFactory.createSession(this.repositoryWorkspaceName);
                previousNamespaceUriForPrefix = session.getNamespacePrefix(namespaceUri);
                javax.jcr.NamespaceRegistry registry = session.getWorkspace().getNamespaceRegistry();
                registry.registerNamespace(prefix, namespaceUri);
            }
            catch (RepositoryException e) {
                throw new org.jboss.dna.graph.properties.NamespaceException((Throwable)e);
            }
            Object var7_7 = null;
            if (session == null) return previousNamespaceUriForPrefix;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (session == null) throw throwable;
            session.logout();
            throw throwable;
        }
        session.logout();
        return previousNamespaceUriForPrefix;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean unregister(String namespaceUri) {
        Session session = null;
        try {
            session = this.sessionFactory.createSession(this.repositoryWorkspaceName);
            String prefix = session.getNamespacePrefix(namespaceUri);
            javax.jcr.NamespaceRegistry registry = session.getWorkspace().getNamespaceRegistry();
            registry.unregisterNamespace(prefix);
        }
        catch (NamespaceException e) {
            boolean bl = false;
            Object var6_9 = null;
            if (session == null) return bl;
            session.logout();
            return bl;
        }
        catch (RepositoryException e) {
            try {
                throw new org.jboss.dna.graph.properties.NamespaceException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                if (session == null) throw throwable;
                session.logout();
                throw throwable;
            }
        }
        Object var6_8 = null;
        if (session == null) return true;
        session.logout();
        return true;
    }

    public Set<String> getRegisteredNamespaceUris() {
        Set<String> set;
        block5: {
            Session session = null;
            try {
                session = this.sessionFactory.createSession(this.repositoryWorkspaceName);
                javax.jcr.NamespaceRegistry registry = session.getWorkspace().getNamespaceRegistry();
                HashSet<String> result = new HashSet<String>();
                for (String uri : registry.getURIs()) {
                    result.add(uri);
                }
                set = Collections.unmodifiableSet(result);
                Object var9_9 = null;
                if (session == null) break block5;
            }
            catch (RepositoryException e) {
                try {
                    throw new org.jboss.dna.graph.properties.NamespaceException((Throwable)e);
                }
                catch (Throwable throwable) {
                    block6: {
                        Object var9_10 = null;
                        if (session == null) break block6;
                        session.logout();
                    }
                    throw throwable;
                }
            }
            session.logout();
        }
        return set;
    }

    public Set<NamespaceRegistry.Namespace> getNamespaces() {
        Set<NamespaceRegistry.Namespace> set;
        block5: {
            Session session = null;
            try {
                session = this.sessionFactory.createSession(this.repositoryWorkspaceName);
                javax.jcr.NamespaceRegistry registry = session.getWorkspace().getNamespaceRegistry();
                HashSet<BasicNamespace> result = new HashSet<BasicNamespace>();
                for (String uri : registry.getURIs()) {
                    String prefix = registry.getPrefix(uri);
                    result.add(new BasicNamespace(prefix, uri));
                }
                set = Collections.unmodifiableSet(result);
                Object var10_10 = null;
                if (session == null) break block5;
            }
            catch (RepositoryException e) {
                try {
                    throw new org.jboss.dna.graph.properties.NamespaceException((Throwable)e);
                }
                catch (Throwable throwable) {
                    block6: {
                        Object var10_11 = null;
                        if (session == null) break block6;
                        session.logout();
                    }
                    throw throwable;
                }
            }
            session.logout();
        }
        return set;
    }
}

