/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.sequencers;

import java.io.IOException;
import java.security.AccessControlContext;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import net.jcip.annotations.Immutable;
import org.jboss.dna.common.collection.Problems;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.NamespaceRegistry;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.Property;
import org.jboss.dna.graph.properties.PropertyFactory;
import org.jboss.dna.graph.properties.ValueFactories;
import org.jboss.dna.graph.sequencers.SequencerContext;
import org.jboss.dna.repository.RepositoryI18n;
import org.jboss.dna.repository.mimetype.MimeType;
import org.jboss.dna.repository.sequencers.SequencerException;
import org.jboss.dna.repository.util.JcrExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class SequencerNodeContext
implements SequencerContext {
    private final javax.jcr.Property sequencedProperty;
    private final ValueFactories factories;
    private final Path path;
    private final Set<Property> props;
    private final JcrExecutionContext context;
    private final Problems problems;

    SequencerNodeContext(Node input, javax.jcr.Property sequencedProperty, JcrExecutionContext context, Problems problems) throws RepositoryException {
        assert (input != null);
        assert (sequencedProperty != null);
        assert (context != null);
        assert (problems != null);
        this.context = context;
        this.sequencedProperty = sequencedProperty;
        this.problems = problems;
        this.factories = context.getValueFactories();
        this.path = (Path)this.factories.getPathFactory().create(input.getPath());
        HashSet<Property> props = new HashSet<Property>();
        PropertyIterator iter = input.getProperties();
        while (iter.hasNext()) {
            Property prop;
            javax.jcr.Property jcrProp = iter.nextProperty();
            if (jcrProp.getDefinition().isMultiple()) {
                Value[] jcrVals = jcrProp.getValues();
                Object[] vals = new Object[jcrVals.length];
                int ndx = 0;
                for (Value jcrVal : jcrVals) {
                    vals[ndx++] = this.convert(this.factories, jcrProp.getName(), jcrVal);
                }
                prop = context.getPropertyFactory().create((Name)this.factories.getNameFactory().create(jcrProp.getName()), vals);
            } else {
                Value jcrVal = jcrProp.getValue();
                Object val = this.convert(this.factories, jcrProp.getName(), jcrVal);
                prop = context.getPropertyFactory().create((Name)this.factories.getNameFactory().create(jcrProp.getName()), new Object[]{val});
            }
            props.add(prop);
        }
        this.props = Collections.unmodifiableSet(props);
    }

    private Object convert(ValueFactories factories, String name, Value jcrValue) throws RepositoryException {
        switch (jcrValue.getType()) {
            case 2: {
                return factories.getBinaryFactory().create((Object)jcrValue.getStream());
            }
            case 6: {
                return factories.getBooleanFactory().create(jcrValue.getBoolean());
            }
            case 5: {
                return factories.getDateFactory().create(jcrValue.getDate());
            }
            case 4: {
                return factories.getDoubleFactory().create(jcrValue.getDouble());
            }
            case 3: {
                return factories.getLongFactory().create(jcrValue.getLong());
            }
            case 7: {
                return factories.getNameFactory().create(jcrValue.getString());
            }
            case 8: {
                return factories.getPathFactory().create(jcrValue.getString());
            }
            case 9: {
                return factories.getReferenceFactory().create(jcrValue.getString());
            }
            case 1: {
                return factories.getStringFactory().create(jcrValue.getString());
            }
        }
        throw new RepositoryException(RepositoryI18n.unknownPropertyValueType.text(new Object[]{name, jcrValue.getType()}));
    }

    public AccessControlContext getAccessControlContext() {
        return this.context.getAccessControlContext();
    }

    public ClassLoader getClassLoader(String ... classpath) {
        return this.context.getClassLoader(classpath);
    }

    public ValueFactories getValueFactories() {
        return this.factories;
    }

    public Path getInputPath() {
        return this.path;
    }

    public Set<Property> getInputProperties() {
        return this.props;
    }

    public Property getInputProperty(Name name) {
        CheckArg.isNotNull((Object)name, (String)"name");
        for (Property prop : this.props) {
            if (!name.equals(prop.getName())) continue;
            return prop;
        }
        return null;
    }

    public Problems getProblems() {
        return this.problems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String getMimeType() {
        block12: {
            err = null;
            mimeType = null;
            stream = null;
            stream = this.sequencedProperty.getStream();
            var4_4 = mimeType = MimeType.of(this.path.getLastSegment().getName().getLocalName(), stream);
            var6_6 = null;
            if (stream == null) break block12;
            try {
                stream.close();
            }
            catch (IOException error) {
                if (err != null) break block12;
                err = new SequencerException(error);
            }
        }
        return var4_4;
        catch (Exception error) {
            try {
                err = new SequencerException(error);
                var6_7 = null;
                ** if (stream == null) goto lbl-1000
            }
            catch (Throwable var5_12) {
                block13: {
                    var6_8 = null;
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException error) {
                            if (err != null) break block13;
                            err = new SequencerException(error);
                        }
                    }
                }
                throw var5_12;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    stream.close();
                }
                catch (IOException error) {
                    if (err == null) {
                        err = new SequencerException(error);
                    }
                }
            }
lbl-1000:
            // 4 sources

            {
            }
        }
        if (err != null) {
            throw err;
        }
        return mimeType;
    }

    public Logger getLogger(Class<?> clazz) {
        return this.context.getLogger(clazz);
    }

    public Logger getLogger(String name) {
        return this.context.getLogger(name);
    }

    public LoginContext getLoginContext() {
        return this.context.getLoginContext();
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.factories.getNameFactory().getNamespaceRegistry();
    }

    public PropertyFactory getPropertyFactory() {
        return this.context.getPropertyFactory();
    }

    public Subject getSubject() {
        return this.context.getSubject();
    }
}

