/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.observation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.repository.RepositoryI18n;
import org.jboss.dna.repository.observation.NodeChangeListener;
import org.jboss.dna.repository.observation.NodeChanges;
import org.jboss.dna.repository.services.AbstractServiceAdministrator;
import org.jboss.dna.repository.services.AdministeredService;
import org.jboss.dna.repository.services.ServiceAdministrator;
import org.jboss.dna.repository.util.SessionFactory;

public class ObservationService
implements AdministeredService {
    public static final ProblemLog NO_OP_PROBLEM_LOG = new NoOpProblemLog();
    private Logger logger = Logger.getLogger(this.getClass());
    private ProblemLog problemLog = new DefaultProblemLog();
    private final Statistics statistics = new Statistics();
    private final SessionFactory sessionFactory;
    private final CopyOnWriteArrayList<WorkspaceListener> workspaceListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<EventListener> eventListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<NodeChangeListener> nodeChangeListeners = new CopyOnWriteArrayList();
    private final Administrator administrator = new Administrator();

    public ObservationService(SessionFactory sessionFactory) {
        CheckArg.isNotNull((Object)sessionFactory, (String)"session factory");
        this.sessionFactory = sessionFactory;
    }

    public ServiceAdministrator getAdministrator() {
        return this.administrator;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger != null ? logger : Logger.getLogger(this.getClass());
    }

    public ProblemLog getProblemLog() {
        return this.problemLog;
    }

    public void setProblemLog(ProblemLog problemLog) {
        this.problemLog = problemLog != null ? problemLog : new DefaultProblemLog();
    }

    public boolean addListener(EventListener listener) {
        if (listener == null) {
            return false;
        }
        return this.eventListeners.addIfAbsent(listener);
    }

    public boolean removeListener(EventListener listener) {
        if (listener == null) {
            return false;
        }
        return this.eventListeners.remove(listener);
    }

    public boolean addListener(NodeChangeListener listener) {
        return this.nodeChangeListeners.addIfAbsent(listener);
    }

    public boolean removeListener(NodeChangeListener listener) {
        if (listener == null) {
            return false;
        }
        return this.nodeChangeListeners.remove(listener);
    }

    protected void shutdownService() {
        for (WorkspaceListener listener : this.workspaceListeners) {
            try {
                listener.unregister();
            }
            catch (RepositoryException e) {
                this.logger.error((Throwable)e, RepositoryI18n.errorUnregisteringWorkspaceListenerWhileShuttingDownObservationService, new Object[0]);
            }
        }
    }

    public WorkspaceListener monitor(String repositoryWorkspaceName, String absolutePath, int eventTypes, boolean isDeep, String[] uuids, String[] nodeTypeNames, boolean noLocal) throws RepositoryException {
        WorkspaceListener listener = new WorkspaceListener(repositoryWorkspaceName, eventTypes, absolutePath, isDeep, uuids, nodeTypeNames, noLocal);
        listener.register();
        this.workspaceListeners.add(listener);
        return listener;
    }

    public WorkspaceListener monitor(String repositoryWorkspaceName, String absolutePath, String ... nodeTypeNames) throws RepositoryException {
        return this.monitor(repositoryWorkspaceName, absolutePath, 21, true, null, nodeTypeNames, false);
    }

    public WorkspaceListener monitor(String repositoryWorkspaceName, int eventTypes, String ... nodeTypeNames) throws RepositoryException {
        return this.monitor(repositoryWorkspaceName, "/", eventTypes, true, null, nodeTypeNames, false);
    }

    protected void unregisterListener(WorkspaceListener listener) {
        if (listener != null) {
            this.workspaceListeners.remove(listener);
        }
    }

    protected void processEvents(EventIterator eventIterator, WorkspaceListener listener) {
        CopyOnWriteArrayList<NodeChangeListener> nodeChangeListeners;
        if (eventIterator == null) {
            return;
        }
        ArrayList<Event> events = new ArrayList<Event>();
        while (eventIterator.hasNext()) {
            events.add((Event)eventIterator.next());
        }
        if (!this.getAdministrator().isStarted()) {
            this.statistics.recordIgnoredEventSet(events.size());
            return;
        }
        boolean notifiedSomebody = false;
        CopyOnWriteArrayList<EventListener> eventListeners = this.eventListeners;
        if (!eventListeners.isEmpty()) {
            DelegatingEventIterator eventIter = new DelegatingEventIterator(events.iterator(), events.size());
            for (EventListener eventListener : eventListeners) {
                eventListener.onEvent((EventIterator)eventIter);
            }
            notifiedSomebody = true;
        }
        if (!(nodeChangeListeners = this.nodeChangeListeners).isEmpty()) {
            String repositoryWorkspaceName = listener.getRepositoryWorkspaceName();
            try {
                NodeChanges nodeChanges = NodeChanges.create(repositoryWorkspaceName, events);
                int nodeChangeCount = nodeChanges.size();
                this.statistics.recordNodesChanged(nodeChangeCount);
                for (NodeChangeListener nodeChangeListener : nodeChangeListeners) {
                    nodeChangeListener.onNodeChanges(nodeChanges);
                }
            }
            catch (Throwable t) {
                this.getProblemLog().error(repositoryWorkspaceName, t);
            }
            notifiedSomebody = true;
        }
        if (notifiedSomebody) {
            this.statistics.recordEventSet(events.size());
        } else {
            this.statistics.recordIgnoredEventSet(events.size());
        }
    }

    @ThreadSafe
    public class Statistics {
        @GuardedBy(value="lock")
        private long numberOfEventsIgnored;
        @GuardedBy(value="lock")
        private long numberOfEventsEnqueued;
        @GuardedBy(value="lock")
        private long numberOfEventSetsIgnored;
        @GuardedBy(value="lock")
        private long numberOfEventSetsEnqueued;
        private final AtomicLong numberOfNodeChangesEnqueued = new AtomicLong(0L);
        private final ReadWriteLock lock = new ReentrantReadWriteLock();
        private final AtomicLong startTime = new AtomicLong(System.currentTimeMillis());

        protected Statistics() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Statistics reset() {
            try {
                this.lock.writeLock().lock();
                this.startTime.set(System.currentTimeMillis());
                this.numberOfEventsIgnored = 0L;
                this.numberOfEventsEnqueued = 0L;
                this.numberOfEventSetsIgnored = 0L;
                this.numberOfEventSetsEnqueued = 0L;
                this.numberOfNodeChangesEnqueued.set(0L);
                Object var2_1 = null;
                this.lock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.lock.writeLock().unlock();
                throw throwable;
            }
            return this;
        }

        public long getStartTime() {
            return this.startTime.get();
        }

        public long getNumberOfNodeChangesEnqueued() {
            return this.numberOfNodeChangesEnqueued.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getNumberOfEventsIgnored() {
            try {
                this.lock.readLock().lock();
                long l = this.numberOfEventsIgnored;
                Object var4_2 = null;
                this.lock.readLock().unlock();
                return l;
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                this.lock.readLock().unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getNumberOfEventsEnqueued() {
            try {
                this.lock.readLock().lock();
                long l = this.numberOfEventsEnqueued;
                Object var4_2 = null;
                this.lock.readLock().unlock();
                return l;
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                this.lock.readLock().unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getNumberOfEventSetsEnqueued() {
            try {
                this.lock.readLock().lock();
                long l = this.numberOfEventSetsEnqueued;
                Object var4_2 = null;
                this.lock.readLock().unlock();
                return l;
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                this.lock.readLock().unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getNumberOfEventSetsIgnored() {
            try {
                this.lock.readLock().lock();
                long l = this.numberOfEventSetsIgnored;
                Object var4_2 = null;
                this.lock.readLock().unlock();
                return l;
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                this.lock.readLock().unlock();
                throw throwable;
            }
        }

        protected void recordNodesChanged(long changeCount) {
            this.numberOfNodeChangesEnqueued.addAndGet(changeCount);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void recordEventSet(long eventsInSet) {
            try {
                this.lock.writeLock().lock();
                this.numberOfEventsEnqueued += eventsInSet;
                ++this.numberOfEventSetsEnqueued;
                Object var4_2 = null;
                this.lock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                this.lock.writeLock().unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void recordIgnoredEventSet(long eventsInSet) {
            try {
                this.lock.writeLock().lock();
                this.numberOfEventsIgnored += eventsInSet;
                ++this.numberOfEventSetsIgnored;
                ++this.numberOfEventSetsEnqueued;
                Object var4_2 = null;
                this.lock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                this.lock.writeLock().unlock();
                throw throwable;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @ThreadSafe
    public class WorkspaceListener
    implements EventListener {
        public static final boolean DEFAULT_IS_DEEP = true;
        public static final boolean DEFAULT_NO_LOCAL = false;
        public static final int DEFAULT_EVENT_TYPES = 21;
        public static final String DEFAULT_ABSOLUTE_PATH = "/";
        private final String repositoryWorkspaceName;
        private final Set<String> uuids;
        private final Set<String> nodeTypeNames;
        private final int eventTypes;
        private final String absolutePath;
        private final boolean deep;
        private final boolean noLocal;
        @GuardedBy(value="this")
        private transient Session session;

        protected WorkspaceListener(String repositoryWorkspaceName, int eventTypes, String absPath, boolean isDeep, String[] uuids, String[] nodeTypeNames, boolean noLocal) {
            this.repositoryWorkspaceName = repositoryWorkspaceName;
            this.eventTypes = eventTypes;
            this.deep = isDeep;
            this.noLocal = noLocal;
            this.absolutePath = absPath != null && absPath.trim().length() != 0 ? absPath.trim() : null;
            HashSet<String> newUuids = new HashSet<String>();
            if (uuids != null) {
                for (String uuid : uuids) {
                    if (uuid == null || uuid.trim().length() == 0) continue;
                    newUuids.add(uuid.trim());
                }
            }
            this.uuids = Collections.unmodifiableSet(newUuids);
            HashSet<String> newNodeTypeNames = new HashSet<String>();
            if (nodeTypeNames != null) {
                for (String nodeTypeName : nodeTypeNames) {
                    if (nodeTypeName == null || nodeTypeName.trim().length() == 0) continue;
                    newNodeTypeNames.add(nodeTypeName.trim());
                }
            }
            this.nodeTypeNames = Collections.unmodifiableSet(newNodeTypeNames);
        }

        public String getRepositoryWorkspaceName() {
            return this.repositoryWorkspaceName;
        }

        public int getEventTypes() {
            return this.eventTypes;
        }

        public String getAbsolutePath() {
            return this.absolutePath;
        }

        public boolean isDeep() {
            return this.deep;
        }

        public boolean isNoLocal() {
            return this.noLocal;
        }

        public Set<String> getUuids() {
            return this.uuids;
        }

        public Set<String> getNodeTypeNames() {
            return this.nodeTypeNames;
        }

        public synchronized boolean isRegistered() {
            if (this.session != null && ObservationService.this.getAdministrator().isShutdown()) {
                try {
                    this.unregister();
                }
                catch (RepositoryException re) {
                    String msg = "Error unregistering workspace listener after sequencing system has been shutdow.";
                    Logger.getLogger(this.getClass()).debug((Throwable)re, msg, new Object[0]);
                }
            }
            return this.session != null;
        }

        public synchronized WorkspaceListener register() throws UnsupportedRepositoryOperationException, RepositoryException {
            if (this.session != null) {
                return this;
            }
            this.session = ObservationService.this.getSessionFactory().createSession(this.repositoryWorkspaceName);
            String[] uuids = this.uuids.isEmpty() ? null : this.uuids.toArray(new String[this.uuids.size()]);
            String[] nodeTypeNames = this.nodeTypeNames.isEmpty() ? null : this.nodeTypeNames.toArray(new String[this.nodeTypeNames.size()]);
            this.session.getWorkspace().getObservationManager().addEventListener((EventListener)this, this.eventTypes, this.absolutePath, this.deep, uuids, nodeTypeNames, this.noLocal);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized WorkspaceListener unregister() throws UnsupportedRepositoryOperationException, RepositoryException {
            if (this.session == null) {
                return this;
            }
            try {
                if (this.session.isLive()) {
                    this.session.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
                    this.session.logout();
                }
                Object var2_1 = null;
                this.session = null;
                ObservationService.this.unregisterListener(this);
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.session = null;
                ObservationService.this.unregisterListener(this);
                throw throwable;
            }
            return this;
        }

        public synchronized WorkspaceListener reregister() throws UnsupportedRepositoryOperationException, RepositoryException {
            this.unregister();
            this.register();
            return this;
        }

        public void onEvent(EventIterator events) {
            if (events != null) {
                if (ObservationService.this.getAdministrator().isShutdown()) {
                    try {
                        this.unregister();
                    }
                    catch (RepositoryException re) {
                        String msg = "Error unregistering workspace listener after sequencing system has been shutdow.";
                        Logger.getLogger(this.getClass()).debug((Throwable)re, msg, new Object[0]);
                    }
                } else {
                    ObservationService.this.processEvents(events, this);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DelegatingEventIterator
    implements EventIterator {
        private final Iterator<Event> events;
        private final int size;
        private int position = 0;

        protected DelegatingEventIterator(Iterator<Event> events, int size) {
            this.events = events;
            this.size = size;
        }

        public Event nextEvent() {
            ++this.position;
            return this.events.next();
        }

        public long getPosition() {
            return this.position;
        }

        public long getSize() {
            return this.size;
        }

        public void skip(long skipNum) {
            int i = 0;
            while ((long)i != skipNum) {
                this.next();
                ++i;
            }
        }

        public boolean hasNext() {
            return this.events.hasNext();
        }

        public Object next() {
            return this.events.next();
        }

        public void remove() {
        }
    }

    protected class Administrator
    extends AbstractServiceAdministrator {
        protected Administrator() {
            super(RepositoryI18n.observationServiceName, ServiceAdministrator.State.STARTED);
        }

        protected void doShutdown(ServiceAdministrator.State fromState) {
            super.doShutdown(fromState);
            ObservationService.this.shutdownService();
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) {
            return true;
        }

        protected boolean doCheckIsTerminated() {
            return true;
        }
    }

    protected static class NoOpProblemLog
    implements ProblemLog {
        protected NoOpProblemLog() {
        }

        public void error(String repositoryWorkspaceName, Throwable t) {
        }
    }

    public class DefaultProblemLog
    implements ProblemLog {
        public void error(String repositoryWorkspaceName, Throwable t) {
            ObservationService.this.getLogger().error(t, RepositoryI18n.errorProcessingEvents, new Object[]{repositoryWorkspaceName});
        }
    }

    public static interface ProblemLog {
        public void error(String var1, Throwable var2);
    }
}

