/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.sequencers;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.jboss.dna.common.monitor.ProgressMonitor;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.graph.properties.Binary;
import org.jboss.dna.graph.properties.DateTime;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.NamespaceRegistry;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.PathFactory;
import org.jboss.dna.graph.sequencers.SequencerContext;
import org.jboss.dna.graph.sequencers.SequencerOutput;
import org.jboss.dna.graph.sequencers.StreamSequencer;
import org.jboss.dna.repository.RepositoryI18n;
import org.jboss.dna.repository.observation.NodeChange;
import org.jboss.dna.repository.sequencers.Sequencer;
import org.jboss.dna.repository.sequencers.SequencerConfig;
import org.jboss.dna.repository.sequencers.SequencerException;
import org.jboss.dna.repository.sequencers.SequencerNodeContext;
import org.jboss.dna.repository.sequencers.SequencerOutputMap;
import org.jboss.dna.repository.util.JcrExecutionContext;
import org.jboss.dna.repository.util.RepositoryNodePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamSequencerAdapter
implements Sequencer {
    private SequencerConfig configuration;
    private final StreamSequencer streamSequencer;

    public StreamSequencerAdapter(StreamSequencer streamSequencer) {
        this.streamSequencer = streamSequencer;
    }

    public SequencerConfig getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SequencerConfig configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(Node input, String sequencedPropertyName, NodeChange changes, Set<RepositoryNodePath> outputPaths, JcrExecutionContext execContext, ProgressMonitor progressMonitor) throws RepositoryException, SequencerException {
        try {
            progressMonitor.beginTask(100.0, RepositoryI18n.sequencingPropertyOnNode, new Object[]{sequencedPropertyName, input.getPath()});
            Property sequencedProperty = null;
            try {
                sequencedProperty = input.getProperty(sequencedPropertyName);
            }
            catch (PathNotFoundException e) {
                String msg = RepositoryI18n.unableToFindPropertyForSequencing.text(new Object[]{sequencedPropertyName, input.getPath()});
                throw new SequencerException(msg, e);
            }
            progressMonitor.worked(10.0);
            SequencerOutputMap output = new SequencerOutputMap(execContext.getValueFactories());
            InputStream stream = null;
            Throwable firstError = null;
            ProgressMonitor sequencingMonitor = progressMonitor.createSubtask(50.0);
            try {
                block28: {
                    Object var17_18;
                    Throwable t222;
                    Object var14_16;
                    try {
                        stream = sequencedProperty.getStream();
                        SequencerNodeContext sequencerContext = new SequencerNodeContext(input, sequencedProperty, execContext);
                        this.streamSequencer.sequence(stream, (SequencerOutput)output, (SequencerContext)sequencerContext, sequencingMonitor);
                    }
                    catch (Throwable t3) {
                        block30: {
                            firstError = t3;
                            var14_16 = null;
                            sequencingMonitor.done();
                            if (stream != null) {
                                try {}
                                catch (Throwable throwable) {
                                    Object var17_20 = null;
                                    stream = null;
                                    throw throwable;
                                }
                                try {}
                                catch (Throwable t222) {
                                    if (firstError == null) {
                                        firstError = t222;
                                    }
                                    var17_18 = null;
                                    stream = null;
                                    break block30;
                                }
                                stream.close();
                                var17_18 = null;
                                stream = null;
                            }
                        }
                        if (firstError != null) {
                            throw new SequencerException(firstError);
                        }
                    }
                    var14_16 = null;
                    sequencingMonitor.done();
                    if (stream != null) {
                        try {
                            try {
                                stream.close();
                            }
                            catch (Throwable t222) {
                                if (firstError == null) {
                                    firstError = t222;
                                }
                                var17_18 = null;
                                stream = null;
                                break block28;
                            }
                            var17_18 = null;
                            stream = null;
                        }
                        catch (Throwable throwable) {
                            Object var17_19 = null;
                            stream = null;
                            throw throwable;
                        }
                    }
                }
                if (firstError != null) {
                    throw new SequencerException(firstError);
                }
            }
            catch (Throwable throwable) {
                block31: {
                    Object var14_17 = null;
                    sequencingMonitor.done();
                    if (stream != null) {
                        try {}
                        catch (Throwable throwable2) {
                            Object var17_23 = null;
                            stream = null;
                            throw throwable2;
                        }
                        try {}
                        catch (Throwable t222) {
                            if (firstError == null) {
                                firstError = t222;
                            }
                            Object var17_22 = null;
                            stream = null;
                            break block31;
                        }
                        stream.close();
                        Object var17_21 = null;
                        stream = null;
                    }
                }
                if (firstError == null) throw throwable;
                throw new SequencerException(firstError);
            }
            ProgressMonitor writingProgress = progressMonitor.createSubtask(40.0);
            writingProgress.beginTask((double)outputPaths.size(), RepositoryI18n.writingOutputSequencedFromPropertyOnNodes, new Object[]{sequencedPropertyName, input.getPath(), outputPaths.size()});
            for (RepositoryNodePath outputPath : outputPaths) {
                Object var20_33;
                Session session = null;
                try {
                    String repositoryWorkspaceName = outputPath.getRepositoryWorkspaceName();
                    String nodePath = outputPath.getNodePath();
                    session = execContext.getSessionFactory().createSession(repositoryWorkspaceName);
                    Node outputNode = execContext.getTools().findOrCreateNode(session, nodePath);
                    if (this.saveOutput(outputNode, output, execContext)) {
                        session.save();
                    }
                    var20_33 = null;
                    writingProgress.worked(1.0);
                    if (session == null) continue;
                    session.logout();
                }
                catch (Throwable throwable) {
                    var20_33 = null;
                    writingProgress.worked(1.0);
                    if (session == null) throw throwable;
                    session.logout();
                    throw throwable;
                }
            }
            writingProgress.done();
            Object var22_35 = null;
            progressMonitor.done();
            return;
        }
        catch (Throwable throwable) {
            Object var22_36 = null;
            progressMonitor.done();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean saveOutput(Node outputNode, SequencerOutputMap output, JcrExecutionContext context) throws RepositoryException {
        if (output.isEmpty()) {
            return false;
        }
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        NamespaceRegistry namespaceRegistry = context.getNamespaceRegistry();
        Path outputNodePath = (Path)pathFactory.create(outputNode.getPath());
        Name jcrPrimaryTypePropertyName = (Name)context.getValueFactories().getNameFactory().create("jcr:primaryType");
        for (SequencerOutputMap.Entry entry : output) {
            Path targetNodePath = entry.getPath();
            Name primaryType = entry.getPrimaryTypeValue();
            Path absolutePath = targetNodePath.isAbsolute() ? targetNodePath : outputNodePath.resolve(targetNodePath);
            Path relativePath = absolutePath.relativeTo(outputNodePath);
            Node targetNode = outputNode;
            int max = relativePath.size();
            for (int i = 0; i != max; ++i) {
                Path.Segment segment = relativePath.getSegment(i);
                String qualifiedName = segment.getString(namespaceRegistry);
                if (targetNode.hasNode(qualifiedName)) {
                    targetNode = targetNode.getNode(qualifiedName);
                } else {
                    if (segment.hasIndex()) {
                        qualifiedName = segment.getName().getString(namespaceRegistry);
                    }
                    targetNode = i == max - 1 && primaryType != null ? targetNode.addNode(qualifiedName, primaryType.getString(namespaceRegistry, Path.NO_OP_ENCODER)) : targetNode.addNode(qualifiedName);
                }
                assert (targetNode != null);
            }
            assert (targetNode != null);
            for (SequencerOutputMap.PropertyValue property : entry.getPropertyValues()) {
                String propertyName = property.getName().getString(namespaceRegistry, Path.NO_OP_ENCODER);
                Object value = property.getValue();
                if (jcrPrimaryTypePropertyName.equals(property.getName())) {
                    Logger.getLogger(this.getClass()).trace("Skipping property {0}/{1}={2}", new Object[]{targetNode.getPath(), propertyName, value});
                    continue;
                }
                Logger.getLogger(this.getClass()).trace("Writing property {0}/{1}={2}", new Object[]{targetNode.getPath(), propertyName, value});
                if (value instanceof Boolean) {
                    targetNode.setProperty(propertyName, ((Boolean)value).booleanValue());
                    continue;
                }
                if (value instanceof String) {
                    targetNode.setProperty(propertyName, (String)value);
                    continue;
                }
                if (value instanceof String[]) {
                    targetNode.setProperty(propertyName, (String[])value);
                    continue;
                }
                if (value instanceof Integer) {
                    targetNode.setProperty(propertyName, (long)((Integer)value).intValue());
                    continue;
                }
                if (value instanceof Short) {
                    targetNode.setProperty(propertyName, (long)((Short)value).shortValue());
                    continue;
                }
                if (value instanceof Long) {
                    targetNode.setProperty(propertyName, ((Long)value).longValue());
                    continue;
                }
                if (value instanceof Float) {
                    targetNode.setProperty(propertyName, (double)((Float)value).floatValue());
                    continue;
                }
                if (value instanceof Double) {
                    targetNode.setProperty(propertyName, ((Double)value).doubleValue());
                    continue;
                }
                if (value instanceof Binary) {
                    Object var21_25;
                    Binary binaryValue = (Binary)value;
                    try {
                        binaryValue.acquire();
                        targetNode.setProperty(propertyName, binaryValue.getStream());
                        var21_25 = null;
                    }
                    catch (Throwable throwable) {
                        var21_25 = null;
                        binaryValue.release();
                        throw throwable;
                    }
                    binaryValue.release();
                    {
                        continue;
                    }
                }
                if (value instanceof BigDecimal) {
                    targetNode.setProperty(propertyName, ((BigDecimal)value).doubleValue());
                    continue;
                }
                if (value instanceof DateTime) {
                    targetNode.setProperty(propertyName, ((DateTime)value).toCalendar());
                    continue;
                }
                if (value instanceof Date) {
                    DateTime instant = (DateTime)context.getValueFactories().getDateFactory().create((Date)value);
                    targetNode.setProperty(propertyName, instant.toCalendar());
                    continue;
                }
                if (value instanceof Calendar) {
                    targetNode.setProperty(propertyName, (Calendar)value);
                    continue;
                }
                if (value instanceof Name) {
                    Name nameValue = (Name)value;
                    String stringValue = nameValue.getString(namespaceRegistry);
                    targetNode.setProperty(propertyName, stringValue);
                    continue;
                }
                if (value instanceof Path) {
                    Path pathToReferencedNode = (Path)value;
                    if (!pathToReferencedNode.isAbsolute()) {
                        pathToReferencedNode = outputNodePath.resolve(pathToReferencedNode);
                    }
                    try {
                        Node referencedNode = outputNode.getNode(pathToReferencedNode.getString());
                        targetNode.setProperty(propertyName, referencedNode);
                        continue;
                    }
                    catch (PathNotFoundException e) {
                        String msg = RepositoryI18n.errorGettingNodeRelativeToNode.text(new Object[]{value, outputNode.getPath()});
                        throw new SequencerException(msg, e);
                    }
                }
                if (value == null) {
                    targetNode.setProperty(propertyName, (String)null);
                    continue;
                }
                String msg = RepositoryI18n.unknownPropertyValueType.text(new Object[]{value, value.getClass().getName()});
                throw new SequencerException(msg);
            }
        }
        return true;
    }

    protected String[] extractMixinTypes(Object value) {
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        return null;
    }
}

